/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.client;

import it.bankitalia.reri.sia.sdmx.api.DSDIdentifier;
import it.bankitalia.reri.sia.sdmx.api.DataFlowStructure;
import it.bankitalia.reri.sia.sdmx.api.Dataflow;
import it.bankitalia.reri.sia.sdmx.api.GenericSDMXClient;
import it.bankitalia.reri.sia.sdmx.api.PortableTimeSeries;
import it.bankitalia.reri.sia.sdmx.parser.v21.CodelistParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.CompactDataParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.DataStructureParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.DataflowParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.RestQueryBuilder;
import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.SdmxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class RestSdmxClient
implements GenericSDMXClient {
    protected boolean dotStat = false;
    protected URL wsEndpoint = null;
    protected String name = null;
    protected boolean needsCredentials = false;
    protected boolean containsCredentials = false;
    protected String user = null;
    protected String pw = null;
    private static final String sourceClass = RestSdmxClient.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();

    public RestSdmxClient(String string, URL uRL, boolean bl, boolean bl2) {
        this.wsEndpoint = uRL;
        this.name = string;
        this.needsCredentials = bl;
        this.dotStat = bl2;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block5: {
            String string = null;
            String string2 = null;
            hashMap = null;
            string = this.buildFlowQuery(this.wsEndpoint, "all", "all", "latest");
            string2 = this.runQuery(string, null);
            if (string2 != null && !string2.isEmpty()) {
                logger.finest(string2);
                try {
                    List<Dataflow> list = DataflowParser.parse(string2);
                    if (list.size() > 0) {
                        hashMap = new HashMap<String, Dataflow>();
                        for (Dataflow dataflow : list) {
                            hashMap.put(dataflow.getId(), dataflow);
                        }
                        break block5;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
            }
            throw new SdmxException("The query returned an empty result");
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        String string5 = null;
        Dataflow dataflow = null;
        string4 = this.buildFlowQuery(this.wsEndpoint, string, string2, string3);
        string5 = this.runQuery(string4, null);
        if (string5 != null && !string5.isEmpty()) {
            logger.finest(string5);
            try {
                List<Dataflow> list = DataflowParser.parse(string5);
                if (list.size() < 1) {
                    throw new SdmxException("The query returned zero dataflows");
                }
                dataflow = list.get(0);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return dataflow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier) throws SdmxException {
        String string = null;
        String string2 = null;
        DataFlowStructure dataFlowStructure = null;
        if (dSDIdentifier == null) throw new SdmxException("Null dsd in input");
        string = this.buildDSDQuery(this.wsEndpoint, dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion());
        string2 = this.runQuery(string, null);
        if (string2 == null) throw new SdmxException("The query returned an empty result");
        if (string2.isEmpty()) throw new SdmxException("The query returned an empty result");
        logger.finest(string2);
        try {
            return DataStructureParser.parse(string2).get(0);
        }
        catch (Exception exception) {
            logger.severe("Exception caught parsing results from call to provider " + this.name);
            logger.log(Level.FINER, "Exception: ", exception);
            throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
        }
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3, String string4) throws SdmxException {
        String string5 = null;
        String string6 = null;
        Map<String, String> map = null;
        string5 = this.buildCodelistQuery(this.wsEndpoint, string2, string3, string4);
        string6 = this.runQuery(string5, null);
        if (string6 != null && !string6.isEmpty()) {
            logger.finest(string6);
            try {
                map = CodelistParser.parse(string6);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return map;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        String string5 = null;
        List<PortableTimeSeries> list = null;
        string4 = this.buildDataQuery(this.wsEndpoint, dataflow, string, string2, string3);
        string5 = this.runQuery(string4, "application/vnd.sdmx.structurespecificdata+xml;version=2.1");
        if (string5 != null && !string5.isEmpty()) {
            logger.finest(string5);
            try {
                list = CompactDataParser.parse(string5, dataFlowStructure, dataflow.getId());
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return list;
    }

    @Override
    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    @Override
    public void setCredentials(String string, String string2) {
        this.user = string;
        this.pw = string2;
        this.needsCredentials = false;
        this.containsCredentials = true;
    }

    protected String runQuery(String string, String string2) throws SdmxException {
        Object object;
        logger.entering(sourceClass, "runQuery");
        logger.info("Contacting web service with query: " + string);
        StringBuilder stringBuilder = new StringBuilder(1000);
        try {
            object = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
            httpURLConnection.setRequestMethod("GET");
            this.handleHttpHeaders(httpURLConnection, string2);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                String string3;
                logger.fine("Connection opened. Code: " + n);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                }
            } else {
                String string4 = "Connection failed. HTTP error code : " + n + ", message: " + httpURLConnection.getResponseMessage() + "\n";
                switch (n) {
                    case 400: {
                        string4 = string4 + "SDMX meaning: there is a problem with the syntax of the query";
                        logger.severe(string4);
                        throw new SdmxException(string4);
                    }
                    case 403: {
                        string4 = string4 + "SDMX meaning: The syntax of the query is OK but it has no meaning";
                        logger.severe(string4);
                        throw new SdmxException(string4);
                    }
                    case 404: {
                        string4 = string4 + "SDMX meaning: No results matching the query.";
                        logger.severe(string4);
                        throw new SdmxException(string4);
                    }
                    case 406: {
                        string4 = string4 + "SDMX meaning: Not a supported format.";
                        logger.severe(string4);
                        throw new SdmxException(string4);
                    }
                    case 500: {
                        string4 = string4 + "SDMX meaning: Error on the provider side.";
                        logger.severe(string4);
                        throw new SdmxException(string4);
                    }
                    case 501: {
                        string4 = string4 + "SDMX meaning: Feature not supported.";
                        logger.severe(string4);
                        throw new SdmxException(string4);
                    }
                    case 503: {
                        string4 = string4 + "SDMX meaning: Service temporarily unavailable. Please try again later..";
                        logger.severe(string4);
                        throw new SdmxException(string4);
                    }
                }
                logger.severe(string4);
                throw new SdmxException(string4);
            }
            httpURLConnection.disconnect();
            logger.fine("Connection closed.");
        }
        catch (IOException iOException) {
            logger.severe("Exception caught calling provider " + this.name);
            logger.log(Level.FINER, "Exception: ", iOException);
            throw new SdmxException("Exception. Class: " + iOException.getClass().getName() + " .Message: " + iOException.getMessage());
        }
        logger.exiting(sourceClass, "runQuery");
        object = stringBuilder.toString();
        return object;
    }

    protected void handleHttpHeaders(HttpURLConnection httpURLConnection, String string) {
        if (this.containsCredentials) {
            logger.fine("Setting http authorization");
            String string2 = DatatypeConverter.printBase64Binary((byte[])(this.user + ":" + this.pw).getBytes());
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
        }
        if (string != null) {
            httpURLConnection.setRequestProperty("Accept", string);
        }
    }

    protected String buildDataQuery(URL uRL, Dataflow dataflow, String string, String string2, String string3) throws SdmxException {
        if (uRL != null && dataflow != null && string != null && !string.isEmpty()) {
            String string4 = RestQueryBuilder.getDataQuery(uRL, dataflow.getFullIdentifier(), string, string2, string3);
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + uRL);
    }

    protected String buildDSDQuery(URL uRL, String string, String string2, String string3) throws SdmxException {
        if (uRL != null && string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            String string4 = RestQueryBuilder.getStructureQuery(uRL, string, string2, string3);
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + uRL);
    }

    protected String buildFlowQuery(URL uRL, String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getDataflowQuery(uRL, string, string2, string3);
        return string4;
    }

    protected String buildCodelistQuery(URL uRL, String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getCodelistQuery(uRL, string, string2, string3);
        return string4;
    }
}

