/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.helper;

import it.bankitalia.reri.sia.sdmx.client.SDMXClientFactory;
import it.bankitalia.reri.sia.sdmx.helper.HelperHandler;
import it.bankitalia.reri.sia.sdmx.helper.ProviderNode;
import it.bankitalia.reri.sia.sdmx.helper.SdmxExpansionListener;
import it.bankitalia.reri.sia.sdmx.helper.SdmxNode;
import it.bankitalia.reri.sia.util.Configuration;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class SDMXHelper
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JTextArea sdmxMessages;
    private HelperHandler textAreaHandler = null;
    private Logger logger = Configuration.getSdmxLogger();

    public SDMXHelper() {
        super("SDMX Helper Tool");
        this.setSize(800, 600);
        this.setJMenuBar(this.createMenuBar());
        this.sdmxMessages = new JTextArea();
        this.sdmxMessages.setEditable(false);
        this.sdmxMessages.setBackground(Color.LIGHT_GRAY);
        this.textAreaHandler = new HelperHandler(this.sdmxMessages);
        JScrollPane jScrollPane = new JScrollPane(this.sdmxMessages);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new SdmxNode("SDMX", "List of SDMX Data Providers", true));
        String[] stringArray = SDMXClientFactory.getProviders().keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ProviderNode(stringArray[i], "", true));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new SdmxNode("Calling provider, please wait......", "", false)));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.tree = new JTree(this.treeModel);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.tree.addTreeExpansionListener(new SdmxExpansionListener(this.treeModel));
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().add(this.tree);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane);
        jSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.logger.addHandler(this.textAreaHandler);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.setDefaultCloseOperation(1);
                SDMXHelper.this.logger.removeHandler(SDMXHelper.this.textAreaHandler);
            }
        };
        this.addWindowListener(windowAdapter);
        this.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Actions");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Test", 84);
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    public static void start() {
        new SDMXHelper();
    }

    public static void main(String[] stringArray) {
        new SDMXHelper();
    }
}

