/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.util.Configuration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SdmxProxySelector
extends ProxySelector {
    private final String NO_PROXY = "NOPROXY";
    private Proxy defaultProxy = Proxy.NO_PROXY;
    private Map<String, Proxy> proxyTable = null;
    private static final String sourceClass = SdmxProxySelector.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();

    public SdmxProxySelector(String string, int n) {
        logger.entering(sourceClass, "SdmxProxySelector");
        if (string != null && !string.isEmpty() && !string.equalsIgnoreCase("NOPROXY")) {
            this.defaultProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        }
        this.proxyTable = new Hashtable<String, Proxy>();
        logger.exiting(sourceClass, "SdmxProxySelector");
    }

    public void addToDefaultProxy(String string) {
        logger.entering(sourceClass, "addProxy");
        Proxy proxy = this.proxyTable.get(string);
        if (proxy == null) {
            logger.finer("Default proxy has been added for " + string);
            this.proxyTable.put(string, this.defaultProxy);
        }
        logger.exiting(sourceClass, "addProxy");
    }

    public void addProxy(String string, String string2, String ... stringArray) {
        logger.entering(sourceClass, "addProxy");
        Proxy proxy = null;
        if (string != null && string2 != null && !string.isEmpty() && !string2.isEmpty()) {
            proxy = !string.equalsIgnoreCase("NOPROXY") ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string.trim(), Integer.parseInt(string2.trim()))) : Proxy.NO_PROXY;
            for (String string3 : stringArray) {
                if (string3 == null || string3.isEmpty()) continue;
                this.proxyTable.put(string3, proxy);
                logger.finer("Proxy has been added: '" + proxy + "' for " + string3);
            }
        } else {
            throw new IllegalArgumentException("Proxy settings must be valid. host: '" + string + "', port: '" + string2 + "'");
        }
        logger.exiting(sourceClass, "addProxy");
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        logger.entering(sourceClass, "connectFailed");
        logger.warning("FAILED PROXY CALL to URI: " + uRI + ", socket: " + socketAddress);
        logger.exiting(sourceClass, "connectFailed");
    }

    @Override
    public List<Proxy> select(URI uRI) {
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        logger.entering(sourceClass, "select");
        String string = uRI.getHost();
        if (string != null) {
            logger.finer("Getting proxy for host: " + string);
            Proxy proxy = this.proxyTable.get(string);
            arrayList.add(proxy != null ? proxy : Proxy.NO_PROXY);
            logger.finer("proxy: " + arrayList);
        } else {
            logger.warning("No host component found for " + uRI);
            arrayList.add(Proxy.NO_PROXY);
        }
        logger.exiting(sourceClass, "select");
        return arrayList;
    }

    public Proxy addUrlHostToProxy(URL uRL, Proxy proxy) {
        return this.proxyTable.put(uRL.getHost(), proxy);
    }
}

