% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerTable.R
\name{SsPowerTable}
\alias{SsPowerTable}
\title{Generate a power table}
\usage{
SsPowerTable(effectSize, alpha = 0.05, desiredPower = 0.8, 
   method = "DBMH", option = "ALL", ...)
}
\arguments{
\item{effectSize}{The postulated effect size}

\item{alpha}{The The size of the test, default is 0.05}

\item{desiredPower}{The desired statistical power, default is 0.8}

\item{method}{Analysis method, "DBMH" or "ORH", the default is "DBMH"}

\item{option}{Desired generalization; the default is "RRRC", for random-reader random-cases}

\item{...}{Other necessary parameters, OR or DBM variance components, see details}
}
\value{
A data frame containing following three columns.

\item{numReaders}{The number of readers in the pivotal study.}

\item{numCases}{The number of cases in the pivotal study.}

\item{power}{The calculated statistical power corresponding to the indicated
numbers of readers and cases.}
}
\description{
Generate combinations of numbers of readers J and numbers of cases K
   for desired power and specified generalizations (i.e.,  RRRC or FRRC or RRFC)
}
\details{
Regarding other parameters (...), see details in \link{SsPowerGivenJK}
}
\note{
The procedure is valid for ROC studies only; for FROC studies see Online Appendix Chapter 19.
}
\examples{
## Example of sample size calculation with DBM method
retDbm <- StSignificanceTesting (dataset02, FOM = "Wilcoxon", method = "DBMH")
effectSize <- retDbm$ciDiffTrtRRRC$Estimate
varYTR <- retDbm$varComp$varComp[3]
varYTC <- retDbm$varComp$varComp[4]
varYEps <- retDbm$varComp$varComp[6]
powTab <- SsPowerTable(
effectSize = effectSize, 
method = "DBMH", 
varYTR = varYTR, 
varYTC = varYTC, 
varYEps = varYEps)
print(powTab)

## Example of sample size calculation with OR method
retOR <- StSignificanceTesting (dataset02, FOM = "Wilcoxon", method = "ORH") 
effectSize <- retOR$ciDiffTrtRRRC$Estimate
varCompOR <- retOR$varComp
varTR <- varCompOR$varCov[2]
cov1 <- varCompOR$varCov[3]
cov2 <- varCompOR$varCov[4]
cov3 <- varCompOR$varCov[5]
varEps <- varCompOR$varCov[6]
KStar <- length(dataset02$NL[1,1,,1])
powTab <- SsPowerTable(
effectSize = effectSize, 
method = "ORH",
KStar = KStar,
varTR = varTR, 
cov1 = cov1, 
cov2 = cov2, 
cov3 = cov3, 
varEps = varEps) 
print(powTab)

}
