/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.Serializable;
import weka.classifiers.misc.monotone.DiscreteDistribution;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public class CumulativeDiscreteDistribution
implements Serializable {
    private static final long serialVersionUID = -2959806903004453176L;
    private static final double TOLERANCE = Utils.SMALL;
    private double[] m_cdf;

    public CumulativeDiscreteDistribution(DiscreteEstimator discreteEstimator) {
        this.m_cdf = new double[discreteEstimator.getNumSymbols()];
        if (this.m_cdf.length != 0) {
            this.m_cdf[0] = discreteEstimator.getProbability(0.0);
        }
        for (int i = 1; i < this.m_cdf.length; ++i) {
            this.m_cdf[i] = this.m_cdf[i - 1] + discreteEstimator.getProbability(i);
        }
    }

    public CumulativeDiscreteDistribution(DiscreteDistribution discreteDistribution) {
        this.m_cdf = new double[discreteDistribution.getNumSymbols()];
        if (this.m_cdf.length != 0) {
            this.m_cdf[0] = discreteDistribution.getProbability(0);
        }
        for (int i = 1; i < this.m_cdf.length; ++i) {
            this.m_cdf[i] = this.m_cdf[i - 1] + discreteDistribution.getProbability(i);
        }
    }

    public CumulativeDiscreteDistribution(double[] dArray) throws IllegalArgumentException {
        if (!CumulativeDiscreteDistribution.validCumulativeDistribution(dArray)) {
            throw new IllegalArgumentException("Not a cumulative probability distribution");
        }
        this.m_cdf = new double[dArray.length];
        System.arraycopy(dArray, 0, this.m_cdf, 0, dArray.length);
    }

    public int getNumSymbols() {
        return this.m_cdf != null ? this.m_cdf.length : 0;
    }

    public double getCumulativeProbability(int n) {
        return this.m_cdf[n];
    }

    public double[] toArray() {
        double[] dArray = new double[this.m_cdf.length];
        System.arraycopy(this.m_cdf, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public boolean stochasticDominatedBy(CumulativeDiscreteDistribution cumulativeDiscreteDistribution) throws IllegalArgumentException {
        if (this.getNumSymbols() != cumulativeDiscreteDistribution.getNumSymbols()) {
            throw new IllegalArgumentException("Cumulative distributions are not defined over the same number of symbols");
        }
        for (int i = 0; i < this.m_cdf.length; ++i) {
            if (!(this.m_cdf[i] < cumulativeDiscreteDistribution.m_cdf[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CumulativeDiscreteDistribution)) {
            return false;
        }
        CumulativeDiscreteDistribution cumulativeDiscreteDistribution = (CumulativeDiscreteDistribution)object;
        if (this.m_cdf.length != cumulativeDiscreteDistribution.getNumSymbols()) {
            return false;
        }
        for (int i = 0; i < this.m_cdf.length; ++i) {
            if (!(Math.abs(this.m_cdf[i] - cumulativeDiscreteDistribution.m_cdf[i]) > TOLERANCE)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "[" + this.getNumSymbols() + "]:";
        for (int i = 0; i < this.getNumSymbols(); ++i) {
            string = string + " " + this.getCumulativeProbability(i);
        }
        return string;
    }

    private static boolean validCumulativeDistribution(double[] dArray) {
        if (dArray == null || dArray.length == 0 || Math.abs(dArray[dArray.length - 1] - 1.0) > TOLERANCE || dArray[0] < 0.0) {
            return false;
        }
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < dArray[i - 1] - TOLERANCE)) continue;
            return false;
        }
        return true;
    }
}

