/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcatenatedIterator
implements Iterator {
    private Iterator m_iter0 = null;
    private Iterator m_iter1 = null;
    protected Object m_defaultValue = null;
    protected boolean m_defaultValueSeen = false;

    public ConcatenatedIterator(Iterator iter0, Iterator iter1) {
        this.m_iter0 = iter0;
        this.m_iter1 = iter1;
    }

    public boolean hasNext() {
        return this.m_iter0.hasNext() || this.m_iter1.hasNext() || this.hasDefaultValue() && !this.m_defaultValueSeen;
    }

    public Object next() {
        boolean next0 = this.m_iter0.hasNext();
        boolean next1 = this.m_iter1.hasNext();
        if (next0 || next1) {
            Object next;
            Object e = next = next0 ? this.m_iter0.next() : this.m_iter1.next();
            if (this.hasDefaultValue() && this.m_defaultValue.equals(next)) {
                this.m_defaultValueSeen = true;
            }
            return next;
        }
        if (this.hasDefaultValue() && !this.m_defaultValueSeen) {
            this.m_defaultValueSeen = true;
            return this.m_defaultValue;
        }
        throw new NoSuchElementException("Tried to access next() element from empty concatenated iterator");
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from concatenated iterator");
    }

    public void setDefaultValue(Object defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.m_defaultValue != null;
    }
}

