% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPQuery.R
\docType{class}
\name{KorAPQuery-class}
\alias{KorAPQuery-class}
\alias{KorAPQuery}
\alias{initialize,KorAPQuery-method}
\alias{fetchNext,KorAPQuery-method}
\alias{fetchNext}
\alias{fetchAll,KorAPQuery-method}
\alias{fetchAll}
\alias{fetchRest,KorAPQuery-method}
\alias{fetchRest}
\alias{frequencyQuery,KorAPConnection-method}
\alias{frequencyQuery}
\alias{format.KorAPQuery}
\alias{show,KorAPQuery-method}
\title{Class KorAPQuery}
\usage{
\S4method{initialize}{KorAPQuery}(
  .Object,
  korapConnection = NULL,
  request = NULL,
  vc = "",
  totalResults = 0,
  nextStartIndex = 0,
  fields = c("corpusSigle", "textSigle", "pubDate", "pubPlace", "availability",
    "textClass", "snippet"),
  requestUrl = "",
  webUIRequestUrl = "",
  apiResponse = NULL,
  hasMoreMatches = FALSE,
  collectedMatches = NULL
)

\S4method{fetchNext}{KorAPQuery}(
  kqo,
  offset = kqo@nextStartIndex,
  maxFetch = maxResultsPerPage,
  verbose = kqo@korapConnection@verbose
)

\S4method{fetchAll}{KorAPQuery}(kqo, verbose = kqo@korapConnection@verbose)

\S4method{fetchRest}{KorAPQuery}(kqo, verbose = kqo@korapConnection@verbose)

\S4method{frequencyQuery}{KorAPConnection}(
  kco,
  query,
  vc = "",
  conf.level = 0.95,
  as.alternatives = FALSE,
  ...
)

\method{format}{KorAPQuery}(x, ...)

\S4method{show}{KorAPQuery}(object)
}
\arguments{
\item{.Object}{…}

\item{korapConnection}{KorAPConnection object}

\item{request}{query part of the request URL}

\item{vc}{definition of a virtual corpus}

\item{totalResults}{number of hits the query has yielded}

\item{nextStartIndex}{at what index to start the next fetch of query results}

\item{fields}{what data / metadata fields should be collected}

\item{requestUrl}{complete URL of the API request}

\item{webUIRequestUrl}{URL of a web frontend request corresponding to the API request}

\item{apiResponse}{data-frame representation of the JSON response of the API request}

\item{hasMoreMatches}{logical that signals if more query results can be fetched}

\item{collectedMatches}{matches already fetched from the KorAP-API-server}

\item{kqo}{object obtained from \code{\link{corpusQuery}}}

\item{offset}{start offset for query results to fetch}

\item{maxFetch}{maximum number of query results to fetch}

\item{verbose}{print progress information if true}

\item{kco}{\code{\link{KorAPConnection}} object (obtained e.g. from \code{new("KorAPConnection")}}

\item{query}{string that contains the corpus query. The query language depends on the \code{ql} parameter. Either \code{query} must be provided or \code{KorAPUrl}.}

\item{conf.level}{confidence level of the returned confidence interval (passed through \code{\link{ci}}  to \code{\link{prop.test}}).}

\item{as.alternatives}{LOGICAL that specifies if the query terms should be treated as alternatives. If \code{as.alternatives} is TRUE, the sum over all query hits, instead of the respective vc token sizes is used as total for the calculation of relative frequencies.}

\item{...}{further arguments passed to or from other methods}

\item{x}{KorAPQuery object}

\item{object}{KorAPQuery object}
}
\value{
The \code{kqo} input object with updated slots \code{collectedMatches}, \code{apiResponse}, \code{nextStartIndex}, \code{hasMoreMatches}
}
\description{
\code{KorAPQuery} objects represent the current state of a query to a KorAP server.
New \code{KorAPQuery} objects are typically created by the \code{\link{corpusQuery}} method.

\bold{\code{fetchNext}} fetches the next bunch of results of a KorAP query.

\bold{\code{frequencyQuery}} combines \code{\link{corpusQuery}}, \code{\link{corpusStats}} and
\code{\link{ci}} to compute a table with the relative frequencies and
confidence intervals of one ore multiple search terms across one or multiple
virtual corpora.
}
\examples{
\donttest{q <- new("KorAPConnection") \%>\% corpusQuery("Ameisenplage") \%>\% fetchNext()
q@collectedMatches
}

\donttest{
q <- new("KorAPConnection") \%>\% corpusQuery("Ameisenplage") \%>\% fetchAll()
q@collectedMatches
}

\donttest{
q <- new("KorAPConnection") \%>\% corpusQuery("Ameisenplage") \%>\% fetchRest()
q@collectedMatches
}

\donttest{
new("KorAPConnection", verbose = TRUE) \%>\%
  frequencyQuery(c("Mücke", "Schnake"), paste0("pubDate in ", 2000:2003))
}

}
\references{
\url{https://ids-pub.bsz-bw.de/frontdoor/index/index/docId/9026}
}
