% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPQuery.R
\name{corpusQuery,KorAPConnection-method}
\alias{corpusQuery,KorAPConnection-method}
\alias{corpusQuery}
\title{Method corpusQuery}
\usage{
\S4method{corpusQuery}{KorAPConnection}(
  kco,
  query = if (missing(KorAPUrl))
    stop("At least one of the parameters query and KorAPUrl must be specified.", call. =
    FALSE) else httr::parse_url(KorAPUrl)$query$q,
  vc = if (missing(KorAPUrl)) "" else httr::parse_url(KorAPUrl)$query$cq,
  KorAPUrl,
  metadataOnly = TRUE,
  ql = if (missing(KorAPUrl)) "poliqarp" else httr::parse_url(KorAPUrl)$query$ql,
  fields = c("corpusSigle", "textSigle", "pubDate", "pubPlace", "availability",
    "textClass", "snippet"),
  accessRewriteFatal = TRUE,
  verbose = kco@verbose,
  expand = length(vc) != length(query),
  as.df = FALSE
)
}
\arguments{
\item{kco}{\code{\link{KorAPConnection}} object (obtained e.g. from \code{new("KorAPConnection")}}

\item{query}{string that contains the corpus query. The query language depends on the \code{ql} parameter. Either \code{query} must be provided or \code{KorAPUrl}.}

\item{vc}{string describing the virtual corpus in which the query should be performed. An empty string (default) means the whole corpus, as far as it is license-wise accessible.}

\item{KorAPUrl}{instead of providing the query and vc string parameters, you can also simply copy a KorAP query URL from your browser and use it here (and in \code{KorAPConnection}) to provide all necessary information for the query.}

\item{metadataOnly}{logical that determines whether queries should return only metadata without any snippets. This can also be useful to prevent access rewrites. Note that the default value is TRUE, unless the connection is authorized (currently not possible).}

\item{ql}{string to choose the query language (see \href{https://github.com/KorAP/Kustvakt/wiki/Service:-Search-GET#user-content-parameters}{section on Query Parameters} in the Kustvakt-Wiki for possible values.}

\item{fields}{(meta)data fields that will be fetched for every match.}

\item{accessRewriteFatal}{abort if query or given vc had to be rewritten due to insufficient rights (not yet implemented).}

\item{verbose}{print some info}

\item{expand}{logical that decides if \code{query} and \code{vc} parameters are expanded to all of their combinations}

\item{as.df}{return result as data frame instead of as S4 object?}
}
\value{
Depending on the \code{as.df} parameter, a table or a \code{\link{KorAPQuery}} object that, among other information, contains the total number of results in \code{@totalResults}. The resulting object can be used to fetch all query results (with \code{\link{fetchAll}}) or the next page of results (with \code{\link{fetchNext}}).
A corresponding URL to be used within a web browser is contained in \code{@webUIRequestUrl}
Please make sure to check \code{$collection$rewrites} to see if any unforeseen access rewrites of the query's virtual corpus had to be performed.
}
\description{
Perform a corpus query via a connection to a KorAP-API-server.
}
\examples{
# Fetch metadata of every query hit for "Ameisenplage" and show a summary
\donttest{
new("KorAPConnection") \%>\% corpusQuery("Ameisenplage") \%>\% fetchAll()
}

# Use the copy of a KorAP-web-frontend URL for an API query of "Ameise" in a virtual corpus
# and show the number of query hits (but don't fetch them).

new("KorAPConnection", verbose = TRUE) \%>\%
 corpusQuery(KorAPUrl =
   "https://korap.ids-mannheim.de/?q=Ameise&cq=pubDate+since+2017&ql=poliqarp")

# Plot the time/frequency curve of "Ameisenplage"
\donttest{
new("KorAPConnection", verbose=TRUE) \%>\%
  { . ->> kco } \%>\%
  corpusQuery("Ameisenplage") \%>\%
  fetchAll() \%>\%
  slot("collectedMatches") \%>\%
  mutate(year = lubridate::year(pubDate)) \%>\%
  dplyr::select(year) \%>\%
  group_by(year) \%>\%
  summarise(Count = n()) \%>\%
  mutate(Freq = mapply(function(f, y)
    f / corpusStats(kco, paste("pubDate in", y))@tokens, Count, year)) \%>\%
  dplyr::select(-Count) \%>\%
  complete(year = min(year):max(year), fill = list(Freq = 0)) \%>\%
  plot(type = "l")
}
}
\references{
\url{https://ids-pub.bsz-bw.de/frontdoor/index/index/docId/9026}
}
\seealso{
\code{\link{KorAPConnection}}, \code{\link{fetchNext}}, \code{\link{fetchRest}}, \code{\link{fetchAll}}, \code{\link{corpusStats}}
}
