% Generated by roxygen2 (4.0.1): do not edit by hand
\name{extract.lmeDesign}
\alias{extract.lmeDesign}
\alias{extract.lmerModDesign}
\title{Extract the Design of a linear mixed model}
\usage{
extract.lmeDesign(m)
}
\arguments{
\item{m}{fitted \code{lme}- or \code{mer}-Object}
}
\value{
a list with components
\itemize{
\item \code{Vr} estimated covariance of the random effects divided by the
estimated variance of the residuals
\item \code{X} design of the fixed effects
\item \code{Z} design of the random effects
\item \code{sigmasq} variance of the residuals
\item \code{lambda} ratios of the variances of the random effects and the
variance of the residuals
\item \code{y} response variable
}
}
\description{
These functions extract various elements of the design of a fitted
\code{lme}-, \code{mer} or \code{lmerMod}-Object.  They are called by
\code{exactRLRT} and \code{exactLRT}.
}
\examples{
library(nlme)
design <- extract.lmeDesign(lme(distance ~ age + Sex, data = Orthodont,
                             random = ~ 1))
str(design)
}
\author{
Fabian Scheipl, \code{extract.lmerModDesign} by Ben Bolker.
Many thanks to Andrzej Galecki and Tomasz Burzykowski for bug fixes.
}
\keyword{utilities}

