% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_one_trial.R
\name{simulate_one_trial}
\alias{simulate_one_trial}
\title{Simulate One Trial Using an Obtained Optimal Dose Escalation Rule}
\usage{
simulate_one_trial(escalation_rule, prob_true, seed = NULL)
}
\arguments{
\item{escalation_rule}{An object of class \link[RLescalation]{EscalationRule}
specifying an obtained optimal dose escalation rule.}

\item{prob_true}{A numeric vector specifying the true DLT probabilities.}

\item{seed}{An integer value. Random seed for data generation in this trial.}
}
\value{
A data frame which contains the cohort ID, the assigned dose,
the number of assigned patients, the number of DLTs, and the recommended
action including down, stay, up, MTD_1, ..., MTD_J, no_MTD,
and fail to determine MTD.
}
\description{
Simulate One Trial Using an Obtained Optimal Dose Escalation Rule
}
\examples{
library(RLescalation)

\dontrun{
escalation_rule <- learn_escalation_rule(
  J = 6, target = 0.25, epsilon = 0.04, delta = 0.1,
  N_total = 36, N_cohort = 3, seed = 123,
  rl_config = rl_config_set(iter = 1000)
)}

prob_true <- c(0.03, 0.13, 0.17, 0.19, 0.26, 0.31)

# Simulate one trial using the obtained `escalation_rule`
\dontrun{
sim_one <- simulate_one_trial(escalation_rule, prob_true, seed = 123)}

}
