% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLumModel-package.R
\docType{data}
\name{ExampleData.ModelOutput}
\alias{ExampleData.ModelOutput}
\alias{model.output}
\title{Example data (TL curve) simulated from Bailey (2001 ,fig. 1)}
\format{A RLum.Analysis object containing one TL curve as RLum.Data.Curve.}
\source{
\bold{model_LuminescenceSignals()}
}
\description{
Example data (TL curve) simulated from Bailey (2001 ,fig. 1)
}
\note{
This example has only one record (TL). The used sequence was
sequence <- list(IRR = c(temp = 20, dose = 10, DoseRate = 1),
                 TL = c(temp_begin = 20, temp_end = 400, heating_rate = 5))
}
\examples{

data(ExampleData.ModelOutput)
TL_curve <- get_RLum(model.output, recordType = "TL$", drop = FALSE)

##plot TL curve
plot_RLum(TL_curve)

TL_concentrations <- get_RLum(model.output, recordType = "(TL)", drop = FALSE)
plot_RLum(TL_concentrations)


}
\references{
Friedrich, Johannes, Sebastian Kreutzer and Christoph Schmidt. 
Solving ordinary differential equations to understand luminescence:
RLumModel, an advanced research tool for simulating luminescence in quartz using R. 
Quaternary Geochronology 2016.
}
\keyword{datasets}

