% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTemperatureTimeseries.R
\name{generateTemperatureTimeseries}
\alias{generateTemperatureTimeseries}
\title{Returns time series of Daily Maximum and Minimum with a random multi-realization obtained by using \code{\link{newVARmultieventRealization}}. This function is called by  \code{\link{ComprehensiveTemperatureGenerator}}.}
\usage{
generateTemperatureTimeseries(std_tn, std_tx, SplineTx, SplineTn, SplineTm,
  SplineDeltaT, std_tm, var = NULL, exogen = NULL, normalize = TRUE,
  type = 3, extremes = TRUE, sample = NULL, option = 1, original_data,
  origin_x = NULL, origin_data = NULL, noise = NULL)
}
\arguments{
\item{std_tn}{vector containing standard deviation of daily minimum temperature anomalies. \code{stdTn} is default, see \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}

\item{std_tx}{vector containing standard deviation of daily maximum temperature anomalies. \code{stdTx} is default, see \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}

\item{SplineTx}{matrix containing the averaged daily maximum temperature  obtained by a spline interpolation of monthly means . \code{SplineAdvTx} is default, see \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}

\item{SplineTn}{matrix containing the averaged daily minimum temperature  obtained by a spline interpolation of monthly means . \code{SplineAdvTn} is default, see \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}

\item{SplineTm}{matrix containing the averaged daily "mean" temperature   obtained by a spline interpolation of monthly means . \code{SplineAdvTm} is default, see \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}

\item{SplineDeltaT}{matrix containing the rescaled averaged daily temperature range obtained by a spline interpolation of monthly means. \code{SplineAdvDelta_T_sim/SplineAdvDelta_T} is default, see \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}

\item{std_tm}{vector containing standard deviation of daily "mean" temperature anomalies. \code{stdTn} is default, see \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}

\item{var}{A VAR model represented by a \code{varest} object as returned by \code{\link{getVARmodel}} or \code{\link{VAR}}}

\item{exogen}{see \code{\link{VAR}}}

\item{normalize}{logical variable If \code{TRUE} \code{\link{normalizeGaussian_severalstations}} is used, otherwise not. If \code{option} is 2, it is always \code{TRUE}.}

\item{type}{see \code{\link{quantile}}}

\item{sample, origin_x, origin_data, extremes}{see \code{\link{normalizeGaussian_severalstations}}}

\item{option}{integer value. If 1, the generator works with minimum and maximum temperature, if 2 (Default) it works with th average value between maximum and minimum temparature and the respective daily Thermal Range.}

\item{original_data}{matrix containing the measured standardized temperature anomalies}

\item{noise}{stochastic noise to add for variabile generation. Default is \code{NULL}. See \code{\link{newVARmultieventRealization}}.}
}
\value{
This function returns a list of the following variables: 

\code{res_multigen} matrix containing standardized values of daily maximum and minimum temperature anomalies

\code{Tx_spline} matrix containing climatic "spline-interpolated" daily maximum temperature 

\code{Tn_spine} matrix containing climatic "spline-interpolated" daily minimum temperature 

\code{Tx_gen} matrix containing generated daily maximum daily temperature (\eqn{Tx_{gen}})

\code{Tn_gen} matrix containing generated daily minimum daily temperature (\eqn{Tn_{gen}})

\code{Tm_gen} matrix containing generated "mean" daily temperature defined as  \eqn{\frac{Tx_{gen}+Tn_{gen}}{2}}

\code{DeltaT_gen} matrix containing generated daily thermal range defined as  \eqn{Tx_{gen}-Tn_{gen}}

See the R code for further details
}
\description{
Returns time series of Daily Maximum and Minimum with a random multi-realization obtained by using \code{\link{newVARmultieventRealization}}. This function is called by  \code{\link{ComprehensiveTemperatureGenerator}}.
}
\author{
Emanuele Cordano, Emanuele Eccel
}
\seealso{
\code{\link{newVARmultieventRealization}},\code{\link{normalizeGaussian_severalstations}}
}

