% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gramm.R
\name{gramm}
\alias{gramm}
\title{Gramm Matrices}
\usage{
gramm(x, kernel, sigma, degree, scale)
}
\arguments{
\item{x}{Matrix of predictors}

\item{kernel}{Type of kernel used to compute a gramm matrix}

\item{sigma}{Hyperparameters for radial kernels}

\item{degree, scale}{Hyperparameter for polynomial kernel}
}
\value{
Gramm matrix
}
\description{
This function creates a single gramm matrix for traning set based upon several types of kernels.
}
\examples{
library(kernlab)
data(benchmark.data)
example.data=benchmark.data[[1]]
#Generate linear kernel matrix
gramm(example.data[,1:2],'linear',0,0,0)
#Generate radial kernel matrices with different values for the hyperparameter.
gramm(example.data[,1:2],'radial',2^seq(-3:0),0,0)
}
