% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getLabel.R
\name{getLabel}
\alias{getLabel}
\title{Node Labels}
\usage{
getLabel(object)
}
\arguments{
\item{object}{A graph or node object.}
}
\value{
A character vector.
}
\description{
Get all node labels for a given node object or for the entire graph database.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, c("Person", "Student"), name = "Bob")

getLabel(alice)
getLabel(graph)
}
}
\seealso{
\code{\link{addLabel}}, \code{\link{dropLabel}}
}

