% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.R
\name{ROI_solve}
\alias{ROI_solve}
\title{Solve an Optimization Problem}
\usage{
ROI_solve(x, solver, control = list(), ...)
}
\arguments{
\item{x}{an optimization problem of class \code{"OP"}.}

\item{solver}{a character vector specifying the solver to use. If
missing, then the default solver returned by
\code{\link{ROI_options}} is used.}

\item{control}{a list with additional control parameters for the
solver.  This is solver specific so please consult the
corresponding documentation.}

\item{...}{a list of control parameters (overruling those
specified in \code{control}).}
}
\value{
a list containing the solution and a message from the
    solver.
}
\description{
Solve a given optimization problem.  This function
    uses the given solver (or searches for an appropriate solver)
    to solve the supplied optimization problem.
}
\examples{
## Rosenbrock Banana Function
## -----------------------------------------
## objective
f <- function(x) {
   return( 100 * (x[2] - x[1] * x[1])^2 + (1 - x[1])^2 )
}
## gradient
g <- function(x) {
   return( c( -400 * x[1] * (x[2] - x[1] * x[1]) - 2 * (1 - x[1]),
             200 * (x[2] - x[1] * x[1])) )
}
## bounds
b <- V_bound(li = 1:2, ui = 1:2, lb = c(-3, -3), ub = c(3, 3))
op <- OP( objective = F_objective(f, n = 1L, G = g),
          bounds = b )
res <- ROI_solve( op, solver = "nlminb", control = list(start = c( -1.2, 1 )) )
solution( res )
## Portfolio optimization - minimum variance
## -----------------------------------------
## get monthly returns of 30 US stocks
data( US30 )
r <- na.omit( US30 )
## objective function to minimize
obj <- Q_objective( 2*cov(r) )
## full investment constraint
full_invest <- L_constraint( rep(1, ncol(US30)), "==", 1 )
## create optimization problem / long-only
op <- OP( objective = obj, constraints = full_invest )
## solve the problem - only works if a QP solver is registered
\dontrun{
res <- ROI_solve( op )
res
sol <- solution( res )
names( sol ) <- colnames( US30 )
round( sol[ which(sol > 1/10^6) ], 3 )
}
}
\author{
Stefan Theussl
}
