% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{C_constraint}
\alias{C_constraint}
\alias{as.C_constraint}
\alias{is.C_constraint}
\alias{length.C_constraint}
\alias{variable.names.C_constraint}
\alias{terms.C_constraint}
\title{Conic Constraints}
\usage{
C_constraint(L, cones, rhs, names = NULL)

as.C_constraint(x, ...)

is.C_constraint(x)

\method{length}{C_constraint}(x)

\method{variable.names}{C_constraint}(object, ...)

\method{terms}{C_constraint}(x, ...)
}
\arguments{
\item{L}{a numeric vector of length \eqn{n} (a single constraint)
or a matrix of dimension \eqn{m \times n}, where \eqn{n} is the
number of objective variables and \eqn{m} is the number of
constraints. Matrices can be of class
\code{"simple_triplet_matrix"} to allow a sparse representation of
constraints.}

\item{cones}{an object of class \code{"cone"} created by the combination,
of \code{\link{K_zero}}, \code{\link{K_lin}}, \code{\link{K_soc}}, 
\code{\link{K_psd}}, \code{\link{K_expp}}, \code{\link{K_expd}}, 
\code{\link{K_powp}} or \code{\link{K_powd}}.}

\item{rhs}{a numeric vector giving the right hand side of the constraints.}

\item{names}{an optional character vector giving the names of \eqn{x} 
(column names of \eqn{L}).}

\item{x}{an R object.}

\item{...}{further arguments passed to or from other methods
(currently ignored).}

\item{object}{an R object.}
}
\value{
an object of class \code{"C_constraint"} which inherits
        from \code{"constraint"}.
}
\description{
Conic constraints are often written in the form \deqn{Lx + s = rhs}
where \eqn{L} is a \eqn{m \times n} (sparse) matrix and 
\eqn{s \in \mathcal{K}} are the slack variables restricted to
some cone \eqn{\mathcal{K}} which is typically the product of simpler cones 
\eqn{\mathcal{K} = \prod \mathcal{K}_i}. The right hand side \eqn{rhs} 
is a vector of length \eqn{m}.
}
\examples{
## minimize:  x1 + x2 + x3
## subject to: 
##   x1 == sqrt(2)
##   ||(x2, x3)|| <= x1
x <- OP(objective = c(1, 1, 1), 
        constraints = C_constraint(L = rbind(rbind(c(1, 0, 0)), 
                                             diag(x=-1, 3)), 
                                   cones = c(K_zero(1), K_soc(3)), 
                                   rhs = c(sqrt(2), rep(0, 3))), 
        types = rep("C", 3),
        bounds =  V_bound(li = 1:3, lb = rep(-Inf, 3)), maximum = FALSE)
}
