% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPhosFate.R
\name{transportPrerequisites,RPhosFate-method}
\alias{transportPrerequisites,RPhosFate-method}
\alias{transportPrerequisites}
\title{Transport prerequisites}
\usage{
\S4method{transportPrerequisites}{RPhosFate}(x)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Calculates hydraulic radii and determines cells representing inlets as well
as riparian zones before writing them to disk.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)

x <- transportPrerequisites(x)}

}
\references{
\cite{Molnár, P., Ramírez, J.A., 1998. Energy dissipation theories and
optimal channel characteristics of river networks. Water Resources Research
34, 1809–1818.}
}
\seealso{
\code{\link{firstRun}}, \code{\link{subsequentRun}}
}
