% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{control_pca_sample}
\alias{control_pca_sample}
\title{control_pca_sample}
\usage{
control_pca_sample(
  data,
  sel.Gene = "all",
  pairwise.FCh = FALSE,
  point.size = 4,
  point.shape = 19,
  alpha = 0.7,
  colors = c("#66c2a5", "#fc8d62"),
  label.size = 3,
  hjust = 0.5,
  vjust = -1,
  axis.title.size = 11,
  axis.text.size = 10,
  legend.text.size = 11,
  legend.title = "Group",
  legend.title.size = 11,
  legend.position = "right",
  plot.title = "",
  plot.title.size = 14,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "control_pca_samples"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions.
Also, table with fold change values returned from RQ_dCt() and RQ_ddCt() functions can be used,
but in such situation a pairwise.FCh parameter must be set to TRUE.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{pairwise.FCh}{Logical: If fold change values returned from RQ_dCt() and RQ_ddCt() functions
in a pairwise approach are used as data, this parameter should be set to TRUE, otherwise to FALSE (default).}

\item{point.size}{Numeric: size of points. Default to 4.}

\item{point.shape}{Integer: shape of points. Default to 19.}

\item{alpha}{Numeric: transparency of points, a value between 0 and 1. Default to 0.7.}

\item{colors}{Character vector containing colors for compared groups. The number of colors must be equal to the number of groups.
Default to c("#66c2a5", "#fc8d62").}

\item{label.size}{Numeric: size of points labels (names of samples). Default to 3.}

\item{hjust}{Numeric: horizontal position of points labels. Default to 0.}

\item{vjust}{Numeric: vertical position of points labels.  Default to -1.}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.title}{Character: title of legend. Default to "Group".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.position}{Position of the legend, can be "top", "right" (default), "bottom", "left", or "none" (no legend).
See description for legend.position parameter in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{character: name of saved .tiff file, without ".tiff" name of extension. Default to "control_pca_samples".}
}
\value{
Object with plot. The plot is also displayed on the graphic device.
}
\description{
This function performs principal component analysis (PCA) for samples and generate plot that illustrate spatial arrangement
of samples based on the two first components. This plot is useful to identify outlier samples.
PCA analysis can not deal with missing values, thus all samples with at least one missing value are removed from data before analysis.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
control_pca_sample(data.dCt)

}
