% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DianaPerri2.R
\name{DianaPerri2}
\alias{DianaPerri2}
\title{Diana-Perri-2 model}
\usage{
DianaPerri2(z,mu,beta,pi,type=c("total","mean"),cl,N=NULL,method="srswr")
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{mu}{vector with the means of the scramble variables \eqn{W} and \eqn{U}}

\item{beta}{the constant of weighting}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{method}{method used to draw the sample: srswr or srswor. By default it is srswr}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Diana-Perri-2 model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Diana-Perri-2 model.
The function can also return the transformed variable.
The Diana-Perri-2 model was proposed by Diana and Perri (2010, page 1879).
}
\details{
In the Diana-Perri-2 model, each respondent is asked to report the scrambled response \eqn{z_i=W(\beta U+(1-\beta)y_i)} where \eqn{\beta \in [0,1)} is a suitable constant
controlled by the researcher and \eqn{W,U} are scramble variables whose distribution is assumed to be known.

To estimate \eqn{\bar{Y}} a sample of respondents is selected according to simple random sampling with replacement.
The transformed variable is
\deqn{r_i=\frac{z_i-\beta\mu_W\mu_U}{(1-\beta)\mu_W}}
where \eqn{\mu_W,\mu_U} are the means of \eqn{W,U} scramble variables, respectively.

The estimated variance in this model is
\deqn{\widehat{V}(\widehat{\bar{Y}}_R)=\frac{s_z^2}{n(1-\beta)^2\mu_W^2}}
where \eqn{s_z^2=\sum_{i=1}^n\frac{(z_i-\bar{z})^2}{n-1}}.

If the sample is selected by simple random sampling without replacement, the estimated variance is
\deqn{\widehat{V}(\widehat{\bar{Y}}_R)=\frac{s_z^2}{n(1-\beta)^2\mu_W^2}\left(1-\frac{n}{N}\right)}
}
\examples{
N=100000
data(DianaPerri2Data)
dat=with(DianaPerri2Data,data.frame(z,Pi))
beta=0.8
mu=c(50/48,5/3)
cl=0.95
DianaPerri2(dat$z,mu,beta,dat$Pi,"mean",cl,N,"srswor")
}
\references{
Diana, G., Perri, P.F. (2010).
\emph{New scrambled response models for estimating the mean of a sensitive quantitative character.}
Journal of Applied Statistics 37 (11), 1875–1890.
}
\seealso{
\code{\link{DianaPerri2Data}}

\code{\link{DianaPerri1}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{DianaPerri}
\keyword{Estimation}
\keyword{Quantitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

