\name{rsaga.sink.route}
\alias{rsaga.sink.route}
\title{Sink Drainage Route Detection}
\usage{
  rsaga.sink.route(in.dem, out.sinkroute, threshold,
    thrsheight = 100, ...)
}
\arguments{
  \item{in.dem}{input: digital elevation model (DEM) as
  SAGA grid file (default file extension: \code{.sgrd})}

  \item{out.sinkroute}{output: sink route grid file:
  non-sinks obtain a value of 0, sinks are assigned an
  integer between 0 and 8 indicating the direction to which
  flow from this sink should be routed}

  \item{threshold}{logical: use a threshold value?}

  \item{thrsheight}{numeric: threshold value (default:
  \code{100})}

  \item{...}{optional arguments to be passed to
  \code{\link{rsaga.geoprocessor}}, including the
  \code{env} RSAGA geoprocessing environment}
}
\value{
  The type of object returned depends on the \code{intern}
  argument passed to the \code{\link{rsaga.geoprocessor}}.
  For \code{intern=FALSE} it is a numerical error code (0:
  success), or otherwise (default) a character vector with
  the module's console output.
}
\description{
  Sink drainage route detection.
}
\note{
  I assume that flow directions are coded as 0 = north, 1 =
  northeast, 2 = east, ..., 7 = northwest, as in
  \code{\link{rsaga.fill.sinks}}.
}
\examples{
\dontrun{rsaga.sink.route("dem","sinkroute")
rsaga.sink.removal("dem","sinkroute","dem-preproc",method="deepen")}
}
\author{
  Alexander Brenning (R interface), Olaf Conrad (SAGA
  module)
}
\seealso{
  \code{\link{rsaga.sink.removal}}
}
\keyword{interface}
\keyword{spatial}

