% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimResult.R
\docType{class}
\name{SimResult-class}
\alias{SimResult-class}
\alias{SimResult}
\title{CAT simulation result}
\description{
An S4 class to represent CAT simulation results.
}
\section{Slots}{

\describe{
\item{\code{numExaminees}}{a positive integer representing the number of simulated 
examinees.}

\item{\code{trueThetas}}{a numeric vector representing the true theta values of 
simulated examinees.}

\item{\code{finalThetas}}{a numeric vector representing the final theta estimates of 
simulated examinees.}

\item{\code{finalThetaSEs}}{a numeric vector representing the final theta estimate 
standard errors (SEs) of simulated examinees.}

\item{\code{estThetas}}{a list of length \code{numExaminees}. Each element of the 
list is a numeric vector representing theta estimate at adaptive 
stages for the simulated examinee.}

\item{\code{estThetaSEs}}{a list of length \code{numExaminees}. Each element of the 
list is a numeric vector representing theta estimate standard error (SE) 
at adaptive stages for the simulated examinee.}

\item{\code{scores}}{a list of length \code{numExaminees}. Each element of the 
list is a numeric vector representing scores at adaptive stages for the 
simulated examinee. 0 for an incorrect repsonse and 1 for 
a correct respone.}

\item{\code{itemsAdministered}}{a list of length \code{numExaminees}. Each element 
of the list is a character vector representing identifiers of adminsitered 
items at adaptive stages for the simulated examinee.}

\item{\code{shadowTests}}{a list of length \code{numExaminees}. Each element of
the list is also a list representing the shadow test assembled at each 
adaptive stage.}

\item{\code{engineTime}}{a list of length \code{numExaminees}. Each element of
 the list is a numeric vector representing the engine time at each adaptive step.
the engine time includes time consumed by CAT algorithms and shadow test assembly.}
}}

