% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sam.R
\name{sam}
\alias{sam}
\title{Spectral Angle Mapper}
\usage{
sam(x, em, angles = FALSE)
}
\arguments{
\item{x}{RasterBrick or RasterStack. Remote sensing imagery (usually hyperspectral)}

\item{em}{Matrix containing endmembers in rows and bands in columns}

\item{angles}{Logical. If \code{TRUE} a RasterBrick containing each one layer per endmember will be returned containing the spectral angles.}
}
\value{
RasterBrick or RasterLayer
If \code{angles = FALSE} a single Layer will be returned in which each pixel is assigned to the closest endmember class (integer pixel values correspond to row order of \code{em}.
}
\description{
Calculates the angle in spectral space between pixels and a set of reference spectra (endmembers) for image classification based on spectral similarity.
}
\details{
For each pixel the spectral angle mapper calculates the angle between the vector defined by the pixel values and each endmember vector. The result of this is
one raster layer for each endmember containing the spectral angle. The smaller the spectral angle the more similar a pixel is to a given endmember class.
In a second step one can the go ahead an enforce thresholds of maximum angles or simply classify each pixel to the most similar endmember.
}
\examples{
library(raster)
library(ggplot2)
## Load example data-set
data(lsat) 

## Sample endmember spectra 
## First location is water, second is open agricultural vegetation
pts <- data.frame(x = c(624720, 627480), y = c(-414690, -411090))
endmembers <- extract(lsat, pts)
rownames(endmembers) <- c("water", "vegetation")

## Calculate spectral angles
lsat_sam <- sam(lsat, endmembers, angles = TRUE)
plot(lsat_sam)

## Classify based on minimum angle
lsat_sam <- sam(lsat, endmembers, angles = FALSE)

\donttest{ggR(lsat_sam, forceCat = TRUE, geom_raster=TRUE) + 
		scale_fill_manual(values = c("blue", "green"), labels = c("water", "vegetation"))}
}

