% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMeta.R
\name{ImageMetaData}
\alias{ImageMetaData}
\title{ImageMetaData Class}
\usage{
ImageMetaData(file = NA, format = NA, sat = NA, sen = NA, scene = NA,
  proj = NA, date = NA, pdate = NA, path = NA, row = NA, az = NA,
  selv = NA, esd = NA, files = NA, bands = NA, quant = NA, cat = NA,
  na = NA, vsat = NA, scal = NA, dtyp = NA, calrad = NA,
  calref = NA, calbt = NA, radRes = NA, spatRes = NA)
}
\arguments{
\item{file}{Character. Metadata file}

\item{format}{Character. Metadata format, e.g. xml, mtl}

\item{sat}{Character. Satellite platform}

\item{sen}{Character. Sensor}

\item{scene}{Character. Scene_ID}

\item{proj}{CRS. Projection.}

\item{date}{POSIXct. Aquisition date.}

\item{pdate}{POSIXct. Processing date.}

\item{path}{Integer. Path.}

\item{row}{Integer. Row.}

\item{az}{Numeric. Sun azimuth}

\item{selv}{Numeric. Sun elevation}

\item{esd}{Numeric. Earth-sun distance}

\item{files}{Character vector. Files containing the data, e.g. tiff files}

\item{bands}{Character vector. Band names}

\item{quant}{Character vector. Quantity, one of c("dn", "tra", "tre", "sre", "bt", "idx")}

\item{cat}{Character vector. Category, e.g. c("image", "pan", "index", "qa")}

\item{na}{Numeric vector. No-data value per band}

\item{vsat}{Numeric vector. Saturation value per band}

\item{scal}{Numeric vector. Scale factor per band. e.g. if data was scaled to 1000*reflectance for integer conversion.}

\item{dtyp}{Character vector. Data type per band. See \code{\link[raster]{dataType}} for options.}

\item{calrad}{data.frame. Calibration coefficients for dn->radiance conversion. Must have columns 'gain' and 'offset'. Rows named according to \code{bands}.}

\item{calref}{data.frame. Calibration coefficients for dn->reflectance conversion. Must have columns 'gain' and 'offset'. Rows named according to \code{bands}.}

\item{calbt}{data.frame. Calibration coefficients for dn->brightness temperature conversion. Must have columns 'K1' and 'K2'. Rows named according to \code{bands}.}

\item{radRes}{Numeric vector. Radiometric resolution per band.}

\item{spatRes}{Numeric vector. Spatial resolution per band.}
}
\description{
ImageMetaData Class
}
