% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_upload_package_files}
\alias{repo_upload_package_files}
\title{Uploads package file(s) into managed repository.}
\usage{
repo_upload_package_files(repo_manager, files)
}
\arguments{
\item{repo_manager}{repo manager to use for uploading. (type: rsuite_repo_manager)}

\item{files}{vector of files to upload. (type: character)}
}
\description{
Uploads package file(s) into managed repository.
}
\details{
Logs all messages onto rsuite logger. Use \code{logging::setLevel} to control
logs verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # set it to use in project repository and CRAN
  prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

  # start managing in project repository
  rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

  # download logging package
  pkg_fpath <- utils::download.packages("logging",
                                        repos = "https://cloud.r-project.org/",
                                        destdir = tempdir(),
                                        type = "source")[1,2]

  # upload downloaded package into the repository
  repo_upload_package_files(rmgr, files = pkg_fpath)

  # list available packages
  repo_mng_list(rmgr, pkg_type = "source")

  # stop repository management
  repo_mng_stop(rmgr)
}

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_list}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_pkgzip}},
  \code{\link{repo_upload_prj_packages}}
}
