% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swapIRS.R
\name{swapIRS}
\alias{swapIRS}
\title{\code{swapIRS}}
\usage{
swapIRS(
  trade.date = lubridate::today(),
  eff.date = lubridate::today() + 2,
  mat.date = lubridate::today() + 2 + lubridate::years(2),
  notional = 1e+06,
  PayRec = "Rec",
  fixed.rate = 0.05,
  float.curve = usSwapCurves,
  reset.freq = 3,
  disc.curve = usSwapCurves,
  convention = c("act", 360),
  bus.calendar = "NY",
  output = "price"
)
}
\arguments{
\item{trade.date}{Date object. Defaults to today().}

\item{eff.date}{Date object. Defaults to today() + 2 days.}

\item{mat.date}{Date object. Defaults to today() + 2 years.}

\item{notional}{Numeric value of notional. Defaults to 1,000,000.}

\item{PayRec}{"Pay" or "Rec" fixed.}

\item{fixed.rate}{Numeric fixed interest rate. Defaults to 0.05.}

\item{float.curve}{List of interest rate curves. Defaults to data("usSwapCurves").}

\item{reset.freq}{Numeric where 1 = "monthly", 3 = quarterly, 6 = Semi annual 12 = yearly.}

\item{disc.curve}{List of interest rate curves. Defaults to data("usSwapCurves").}

\item{convention}{Vector of convention e.g. c("act",360) c(30,360),...}

\item{bus.calendar}{Banking day calendar. Not implemented.}

\item{output}{"price" for swap price or "all" for price, cash flow data frame, duration.}
}
\value{
List of swap price, cash flow data frame, duration.
}
\description{
Commodity swap pricing from exchange settlement
}
\examples{
data("usSwapCurves")
swapIRS(trade.date = as.Date("2020-01-04"), eff.date = as.Date("2020-01-06"),
mat.date = as.Date("2022-01-06"), notional = 1000000,
PayRec = "Rec", fixed.rate=0.05, float.curve = usSwapCurves, reset.freq=3,
disc.curve = usSwapCurves, convention = c("act",360),
bus.calendar = "NY", output = "all")
}
\author{
Philippe Cote
}
