% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eia2tidy.R
\name{eia2tidy}
\alias{eia2tidy}
\title{\code{eia2tidy}}
\usage{
eia2tidy(ticker, key, name = " ")
}
\arguments{
\item{ticker}{EIA series name.}

\item{key}{Your private EIA API token as character "<yourapikey>".}

\item{name}{Name you want to give the series. Defaults to ticker if set to " "}
}
\value{
A tibble object with class date for weekly, monthly, quarterly or annual data and class POSIXct for hourly.
}
\description{
Extracts data from the Energy Information Administration (EIA) API to tibble format with optional custom series name.
Makes a clean wrapper for use with purrr for multiple series extraction. Query Browser at https://www.eia.gov/opendata/qb.php.
}
\examples{
\dontrun{
# Single Series
RTL::eia2tidy(ticker = "PET.MCRFPTX2.M", key = "yourapikey", name = "TexasProd")
# Multiple Series
eia_df <-tibble::tribble(~ticker, ~name,
"PET.W_EPC0_SAX_YCUOK_MBBL.W", "CrudeCushing",
"NG.NW2_EPG0_SWO_R48_BCF.W","NGLower48") \%>\%
 dplyr::mutate(key = "EIAkey") \%>\%
 dplyr::mutate(df = purrr::pmap(list(ticker,key,name),.f=RTL::eia2tidy)) \%>\%
 dplyr::select(df) \%>\% tidyr::unnest(df)
 }
}
\author{
Philippe Cote
}
