% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simOU.R
\name{simOU}
\alias{simOU}
\title{OU process simulation}
\usage{
simOU(
  nsims = 2,
  S0 = 5,
  mu = 5,
  theta = 0.5,
  sigma = 0.2,
  T2M = 1,
  dt = 1/12,
  epsilon = NULL
)
}
\arguments{
\item{nsims}{number of simulations. Defaults to 2. \code{numeric}}

\item{S0}{S at t=0. \code{numeric}}

\item{mu}{Mean reversion level. \code{numeric}}

\item{theta}{Mean reversion speed. \code{numeric}}

\item{sigma}{Standard deviation. \code{numeric}}

\item{T2M}{Maturity in years. \code{numeric}}

\item{dt}{Time step size e.g. 1/250 = 1 business day. \code{numeric}}

\item{epsilon}{Defaults to NULL function generates its own. \code{numeric}
OPTIONAL: Array of epsilons for nsims = 1, if you want to feed your own e.g. in a multivariate context.}
}
\value{
Simulated values. \code{tibble}
}
\description{
Simulates a Ornstein–Uhlenbeck process
}
\examples{
simOU(nsims = 5, S0 = 5, mu = 5, theta = .5, sigma = 0.2, T2M = 1, dt = 1 / 12, epsilon = NULL)
simOU(nsims = 1, S0 = 5, mu = 5, theta = .5, sigma = 0.2, T2M = 1, dt = 1 / 12,
epsilon = matrix(rnorm(12,0,sqrt(1/12))))
simOU(nsims = 2, S0 = 5, mu = 5, theta = .5, sigma = 0.2, T2M = 1, dt = 1 / 12,
epsilon = replicate(2,rnorm(12,0,sqrt(1/12))))
}
\author{
Philippe Cote
}
