% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adcomplex.R
\name{ADcomplex}
\alias{ADcomplex}
\alias{adcomplex}
\alias{Re.adcomplex}
\alias{Im.adcomplex}
\alias{show,adcomplex-method}
\alias{dim.adcomplex}
\alias{dim<-.adcomplex}
\alias{[.adcomplex}
\alias{[<-.adcomplex}
\alias{t.adcomplex}
\alias{length.adcomplex}
\alias{Conj.adcomplex}
\alias{Mod.adcomplex}
\alias{Arg.adcomplex}
\alias{+.adcomplex}
\alias{-.adcomplex}
\alias{*.adcomplex}
\alias{/.adcomplex}
\alias{exp.adcomplex}
\alias{log.adcomplex}
\alias{sqrt.adcomplex}
\alias{fft,adcomplex-method}
\alias{fft,advector-method}
\alias{rep.adcomplex}
\alias{as.vector.adcomplex}
\alias{is.matrix.adcomplex}
\alias{as.matrix.adcomplex}
\alias{\%*\%,adcomplex,ANY-method}
\alias{solve,adcomplex,ANY-method}
\alias{colSums,adcomplex-method}
\alias{rowSums,adcomplex-method}
\alias{diag,adcomplex,ANY,ANY-method}
\alias{Ops,advector,adcomplex-method}
\alias{Ops,adcomplex,advector-method}
\title{AD complex numbers}
\usage{
adcomplex(real, imag = rep(advector(0), length(real)))

\method{Re}{adcomplex}(z)

\method{Im}{adcomplex}(z)

\S4method{show}{adcomplex}(object)

\method{dim}{adcomplex}(x)

\method{dim}{adcomplex}(x) <- value

\method{[}{adcomplex}(x, ...)

\method{[}{adcomplex}(x, ...) <- value

\method{t}{adcomplex}(x)

\method{length}{adcomplex}(x)

\method{Conj}{adcomplex}(z)

\method{Mod}{adcomplex}(z)

\method{Arg}{adcomplex}(z)

\method{+}{adcomplex}(x, y)

\method{-}{adcomplex}(x, y)

\method{*}{adcomplex}(x, y)

\method{/}{adcomplex}(x, y)

\method{exp}{adcomplex}(x)

\method{log}{adcomplex}(x, base)

\method{sqrt}{adcomplex}(x)

\S4method{fft}{adcomplex}(z, inverse = FALSE)

\S4method{fft}{advector}(z, inverse = FALSE)

\method{rep}{adcomplex}(x, ...)

\method{as.vector}{adcomplex}(x, mode = "any")

\method{is.matrix}{adcomplex}(x)

\method{as.matrix}{adcomplex}(x, ...)

\S4method{\%*\%}{adcomplex,ANY}(x, y)

\S4method{solve}{adcomplex,ANY}(a, b)

\S4method{colSums}{adcomplex}(x)

\S4method{rowSums}{adcomplex}(x)

\S4method{diag}{adcomplex,ANY,ANY}(x)

\S4method{Ops}{advector,adcomplex}(e1, e2)

\S4method{Ops}{adcomplex,advector}(e1, e2)
}
\arguments{
\item{real}{Real part}

\item{imag}{Imaginary part}

\item{z}{An object of class \code{'adcomplex'}}

\item{object}{An object of class \code{'adcomplex'}}

\item{x}{An object of class \code{'adcomplex'}}

\item{value}{Replacement value}

\item{...}{As \link[base]{[}}

\item{y}{An object of class \code{'adcomplex'}}

\item{base}{Not implemented}

\item{inverse}{As \link[stats]{fft}}

\item{mode}{As \link[base]{as.vector}}

\item{a}{matrix}

\item{b}{matrix, vector or missing}

\item{e1}{Left operand}

\item{e2}{Right operand}
}
\value{
Object of class \code{"adcomplex"}.
}
\description{
A limited set of complex number operations can be used when constructing AD tapes. The available methods are listed in this help page.
}
\section{Functions}{
\itemize{
\item \code{adcomplex()}: Construct \code{adcomplex} vector

\item \code{Re(adcomplex)}: As \link[base]{complex}

\item \code{Im(adcomplex)}: As \link[base]{complex}

\item \code{show(adcomplex)}: Print method

\item \code{dim(adcomplex)}: As \link[base]{dim}

\item \code{dim(adcomplex) <- value}: As \link[base]{dim}

\item \code{[}: As \link[base]{[}

\item \code{`[`(adcomplex) <- value}: As \link[base]{[<-}

\item \code{t(adcomplex)}: As \link[base]{t}

\item \code{length(adcomplex)}: As \link[base]{length}

\item \code{Conj(adcomplex)}: As \link[base]{complex}

\item \code{Mod(adcomplex)}: As \link[base]{complex}

\item \code{Arg(adcomplex)}: As \link[base]{complex}

\item \code{ + }: As \link[base]{complex}

\item \code{ - }: As \link[base]{complex}

\item \code{ * }: As \link[base]{complex}

\item \code{ / }: As \link[base]{complex}

\item \code{exp(adcomplex)}: As \link[base]{complex}

\item \code{log(adcomplex)}: As \link[base]{complex}

\item \code{sqrt(adcomplex)}: As \link[base]{complex}

\item \code{fft(adcomplex)}: Fast Fourier Transform equivalent to \link[stats]{fft}. Notably this is the \strong{multivariate} transform when \code{x} is an array.

\item \code{fft(advector)}: If real input is supplied it is first converted to complex.

\item \code{rep(adcomplex)}: As \link[base]{rep}

\item \code{as.vector(adcomplex)}: Apply for each of real/imag

\item \code{is.matrix(adcomplex)}: Apply for real

\item \code{as.matrix(adcomplex)}: Apply for each of real/imag

\item \code{x \%*\% y}: Complex matrix multiply

\item \code{solve(a = adcomplex, b = ANY)}: Complex matrix inversion and solve

\item \code{colSums(adcomplex)}: Apply for each of real/imag

\item \code{rowSums(adcomplex)}: Apply for each of real/imag

\item \code{diag(x = adcomplex, nrow = ANY, ncol = ANY)}: Apply for each of real/imag

\item \code{Ops(e1 = advector, e2 = adcomplex)}: Mixed real/complex arithmetic

\item \code{Ops(e1 = adcomplex, e2 = advector)}: Mixed real/complex arithmetic

}}
\examples{
## Tape using complex operations
F <- MakeTape(function(x) {
  x <- as.complex(x)
  y <- exp( x * ( 1 + 2i ) )
  c(Re(y), Im(y))
}, numeric(1))
F
F(1)
## Complex FFT on the tape
G <- MakeTape(function(x) sum(Re(fft(x))), numeric(3))
G$simplify()
G$print()
}
