% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.xmlRead.R
\name{xmlReadData_data.frame}
\alias{xmlReadData_data.frame}
\title{Read XML Data From Type 'xmlReadData_data.frame' as R 'data.frame'}
\usage{
xmlReadData_data.frame(xmlItem, na_to_none = FALSE)
}
\arguments{
\item{xmlItem}{(\code{XMLNode}) Object of class \code{XMLNode} that defines the
a data frame and fullfills XSD definition 'xmlReadData_data.frame'.}

\item{na_to_none}{(\code{logical}) Convert NAs to empty characters (i.e. '').}
}
\value{
(\code{data.frame})
}
\description{
Read XML Data From Type 'xmlReadData_data.frame' as R 'data.frame'
}
\examples{
data <- '<data.frame><col-defs>
<coldef name="Column1" type="character"/>
<coldef name="Column2" type="numeric"/>
</col-defs>
<row name="1"><cell>ID1</cell><cell>1</cell></row>
<row name="2"><cell>ID2</cell><cell>2.1</cell></row>
<row name="3"><cell>ID3</cell><cell>3.1</cell></row>
</data.frame>'
item <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))
value <- RTest::xmlReadData_data.frame(item)
stopifnot(dim(value)[1]==3)
stopifnot(dim(value)[2]==2)
}
\seealso{
\code{\link[XML]{XMLNode-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
