/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.part.MakeDecList;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class PART
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 8121455039782598361L;
    private MakeDecList m_root;
    private float m_CF = 0.25f;
    private int m_minNumObj = 2;
    private boolean m_reducedErrorPruning = false;
    private int m_numFolds = 3;
    private boolean m_binarySplits = false;
    private boolean m_unpruned = false;
    private int m_Seed = 1;

    public String globalInfo() {
        return "Class for generating a PART decision list. Uses separate-and-conquer. Builds a partial C4.5 decision tree in each iteration and makes the \"best\" leaf into a rule.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Ian H. Witten");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Generating Accurate Rule Sets Without Global Optimization");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Fifteenth International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "J. Shavlik");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "144-151");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        technicalInformation.setValue(TechnicalInformation.Field.PS, "http://www.cs.waikato.ac.nz/~eibe/pubs/ML98-57.ps.gz");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.m_unpruned ? new MakeDecList(null, this.m_minNumObj).getCapabilities() : (this.m_reducedErrorPruning ? new MakeDecList(null, this.m_numFolds, this.m_minNumObj, this.m_Seed).getCapabilities() : new MakeDecList(null, this.m_CF, this.m_minNumObj).getCapabilities());
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        ModelSelection modelSelection = this.m_binarySplits ? new BinC45ModelSelection(this.m_minNumObj, instances) : new C45ModelSelection(this.m_minNumObj, instances);
        this.m_root = this.m_unpruned ? new MakeDecList(modelSelection, this.m_minNumObj) : (this.m_reducedErrorPruning ? new MakeDecList(modelSelection, this.m_numFolds, this.m_minNumObj, this.m_Seed) : new MakeDecList(modelSelection, this.m_CF, this.m_minNumObj));
        this.m_root.buildClassifier(instances);
        if (this.m_binarySplits) {
            ((BinC45ModelSelection)modelSelection).cleanup();
        } else {
            ((C45ModelSelection)modelSelection).cleanup();
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option("\tSet confidence threshold for pruning.\n\t(default 0.25)", "C", 1, "-C <pruning confidence>"));
        vector.addElement(new Option("\tSet minimum number of objects per leaf.\n\t(default 2)", "M", 1, "-M <minimum number of objects>"));
        vector.addElement(new Option("\tUse reduced error pruning.", "R", 0, "-R"));
        vector.addElement(new Option("\tSet number of folds for reduced error\n\tpruning. One fold is used as pruning set.\n\t(default 3)", "N", 1, "-N <number of folds>"));
        vector.addElement(new Option("\tUse binary splits only.", "B", 0, "-B"));
        vector.addElement(new Option("\tGenerate unpruned decision list.", "U", 0, "-U"));
        vector.addElement(new Option("\tSeed for random data shuffling (default 1).", "Q", 1, "-Q <seed>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        this.m_unpruned = Utils.getFlag('U', stringArray);
        this.m_reducedErrorPruning = Utils.getFlag('R', stringArray);
        this.m_binarySplits = Utils.getFlag('B', stringArray);
        String string2 = Utils.getOption('C', stringArray);
        if (string2.length() != 0) {
            if (this.m_reducedErrorPruning) {
                throw new Exception("Setting CF doesn't make sense for reduced error pruning.");
            }
            this.m_CF = new Float(string2).floatValue();
            if (this.m_CF <= 0.0f || this.m_CF >= 1.0f) {
                throw new Exception("CF has to be greater than zero and smaller than one!");
            }
        } else {
            this.m_CF = 0.25f;
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            if (!this.m_reducedErrorPruning) {
                throw new Exception("Setting the number of folds does only make sense for reduced error pruning.");
            }
            this.m_numFolds = Integer.parseInt(string);
        } else {
            this.m_numFolds = 3;
        }
        String string3 = Utils.getOption('M', stringArray);
        this.m_minNumObj = string3.length() != 0 ? Integer.parseInt(string3) : 2;
        String string4 = Utils.getOption('Q', stringArray);
        this.m_Seed = string4.length() != 0 ? Integer.parseInt(string4) : 1;
    }

    public String[] getOptions() {
        String[] stringArray = new String[11];
        int n = 0;
        if (this.m_unpruned) {
            stringArray[n++] = "-U";
        }
        if (this.m_reducedErrorPruning) {
            stringArray[n++] = "-R";
        }
        if (this.m_binarySplits) {
            stringArray[n++] = "-B";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_minNumObj;
        if (!this.m_reducedErrorPruning) {
            stringArray[n++] = "-C";
            stringArray[n++] = "" + this.m_CF;
        }
        if (this.m_reducedErrorPruning) {
            stringArray[n++] = "-N";
            stringArray[n++] = "" + this.m_numFolds;
        }
        stringArray[n++] = "-Q";
        stringArray[n++] = "" + this.m_Seed;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        return "PART decision list\n------------------\n\n" + this.m_root.toString();
    }

    public String toSummaryString() {
        return "Number of rules: " + this.m_root.numRules() + "\n";
    }

    public double measureNumRules() {
        return this.m_root.numRules();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(string + " not supported (PART)");
    }

    public String confidenceFactorTipText() {
        return "The confidence factor used for pruning (smaller values incur more pruning).";
    }

    public float getConfidenceFactor() {
        return this.m_CF;
    }

    public void setConfidenceFactor(float f) {
        this.m_CF = f;
    }

    public String minNumObjTipText() {
        return "The minimum number of instances per rule.";
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public void setMinNumObj(int n) {
        this.m_minNumObj = n;
    }

    public String reducedErrorPruningTipText() {
        return "Whether reduced-error pruning is used instead of C.4.5 pruning.";
    }

    public boolean getReducedErrorPruning() {
        return this.m_reducedErrorPruning;
    }

    public void setReducedErrorPruning(boolean bl) {
        this.m_reducedErrorPruning = bl;
    }

    public String unprunedTipText() {
        return "Whether pruning is performed.";
    }

    public boolean getUnpruned() {
        return this.m_unpruned;
    }

    public void setUnpruned(boolean bl) {
        this.m_unpruned = bl;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for reduced-error pruning.  One fold is used for pruning, the rest for growing the rules.";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int n) {
        this.m_numFolds = n;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data when reduced-error pruning is used.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public String binarySplitsTipText() {
        return "Whether to use binary splits on nominal attributes when building the partial trees.";
    }

    public boolean getBinarySplits() {
        return this.m_binarySplits;
    }

    public void setBinarySplits(boolean bl) {
        this.m_binarySplits = bl;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new PART(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

