/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import weka.core.Memory;
import weka.core.Utils;
import weka.core.Version;
import weka.gui.LookAndFeel;

public class SystemInfo {
    private Hashtable m_Info = new Hashtable();

    public SystemInfo() {
        this.readProperties();
    }

    private void readProperties() {
        this.m_Info.clear();
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            this.m_Info.put(obj, properties.get(obj));
        }
        this.m_Info.put("weka.version", Version.VERSION);
        String[] stringArray = LookAndFeel.getInstalledLookAndFeels();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + stringArray[i];
        }
        this.m_Info.put("ui.installedLookAndFeels", string);
        this.m_Info.put("ui.currentLookAndFeel", LookAndFeel.getSystemLookAndFeel());
        Memory memory = new Memory();
        this.m_Info.put("memory.initial", "" + Utils.doubleToString(Memory.toMegaByte(memory.getInitial()), 1) + "MB" + " (" + memory.getInitial() + ")");
        this.m_Info.put("memory.max", "" + Utils.doubleToString(Memory.toMegaByte(memory.getMax()), 1) + "MB" + " (" + memory.getMax() + ")");
    }

    public Hashtable getSystemInfo() {
        return (Hashtable)this.m_Info.clone();
    }

    public String toString() {
        String string = "";
        Vector vector = new Vector();
        Enumeration enumeration = this.m_Info.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Collections.sort(vector);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.get(i).toString();
            String string3 = this.m_Info.get(string2).toString();
            if (string2.equals("line.separator")) {
                string3 = Utils.backQuoteChars(string3);
            }
            string = string + string2 + ": " + string3 + "\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(new SystemInfo());
    }
}

