/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormDiscrete
extends Expression {
    private static final long serialVersionUID = -8854409417983908220L;
    protected String m_fieldName;
    protected Attribute m_field;
    protected int m_fieldIndex = -1;
    protected String m_fieldValue;
    protected boolean m_mapMissingDefined = false;
    protected double m_mapMissingTo;
    protected int m_fieldValueIndex = -1;

    public NormDiscrete(Element element, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList) throws Exception {
        super(optype, arrayList);
        if (optype != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[NormDiscrete] can only have a continuous optype");
        }
        this.m_fieldName = element.getAttribute("field");
        this.m_fieldValue = element.getAttribute("value");
        String string = element.getAttribute("mapMissingTo");
        if (string != null && string.length() > 0) {
            this.m_mapMissingTo = Double.parseDouble(string);
            this.m_mapMissingDefined = true;
        }
        this.setUpField();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> arrayList) throws Exception {
        super.setFieldDefs(arrayList);
        this.setUpField();
    }

    private void setUpField() throws Exception {
        this.m_fieldIndex = -1;
        this.m_fieldValueIndex = -1;
        this.m_field = null;
        if (this.m_fieldDefs != null) {
            this.m_fieldIndex = this.getFieldDefIndex(this.m_fieldName);
            if (this.m_fieldIndex < 0) {
                throw new Exception("[NormDiscrete] Can't find field " + this.m_fieldName + " in the supplied field definitions.");
            }
            this.m_field = (Attribute)this.m_fieldDefs.get(this.m_fieldIndex);
            if (!this.m_field.isString() && !this.m_field.isNominal()) {
                throw new Exception("[NormDiscrete] reference field " + this.m_fieldName + " must be categorical");
            }
            if (this.m_field.isNominal()) {
                this.m_fieldValueIndex = this.m_field.indexOfValue(this.m_fieldValue);
                if (this.m_fieldValueIndex < 0) {
                    throw new Exception("[NormDiscrete] Unable to find value " + this.m_fieldValue + " in nominal attribute " + this.m_field.name());
                }
            } else if (this.m_field.isString()) {
                this.m_fieldValueIndex = this.m_field.addStringValue(this.m_fieldValue);
            }
        }
    }

    @Override
    protected Attribute getOutputDef() {
        return new Attribute(this.m_fieldName + "=" + this.m_fieldValue);
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        double d = 0.0;
        if (Instance.isMissingValue(dArray[this.m_fieldIndex])) {
            d = this.m_mapMissingDefined ? this.m_mapMissingTo : dArray[this.m_fieldIndex];
        } else if (this.m_fieldValueIndex == (int)dArray[this.m_fieldIndex]) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public String getResultCategorical(double[] dArray) throws Exception {
        throw new Exception("[NormDiscrete] Can't return the result as a categorical value!");
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NormDiscrete: " + this.m_fieldName + "=" + this.m_fieldValue);
        if (this.m_mapMissingDefined) {
            stringBuffer.append("\n" + string + "map missing values to: " + this.m_mapMissingTo);
        }
        return stringBuffer.toString();
    }
}

