/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.FastVector;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.gui.GenericArrayEditor;
import weka.gui.PropertySelectorDialog;

public class GeneratorPropertyIteratorPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -6026938995241632139L;
    protected JButton m_ConfigureBut = new JButton("Select property...");
    protected JComboBox m_StatusBox = new JComboBox();
    protected GenericArrayEditor m_ArrayEditor = new GenericArrayEditor();
    protected Experiment m_Exp;
    protected FastVector m_Listeners = new FastVector();

    public GeneratorPropertyIteratorPanel() {
        String[] stringArray = new String[]{"Disabled", "Enabled"};
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        this.m_StatusBox.setModel(defaultComboBoxModel);
        this.m_StatusBox.setSelectedIndex(0);
        this.m_StatusBox.addActionListener(this);
        this.m_StatusBox.setEnabled(false);
        this.m_ConfigureBut.setEnabled(false);
        this.m_ConfigureBut.addActionListener(this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_StatusBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_ConfigureBut, gridBagConstraints);
        jPanel.setMaximumSize(new Dimension(jPanel.getMaximumSize().width, jPanel.getMinimumSize().height));
        this.setBorder(BorderFactory.createTitledBorder("Generator properties"));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.m_ArrayEditor.setBorder(BorderFactory.createEtchedBorder());
        this.m_ArrayEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.err.println("Updating experiment property iterator array");
                GeneratorPropertyIteratorPanel.this.m_Exp.setPropertyArray(GeneratorPropertyIteratorPanel.this.m_ArrayEditor.getValue());
            }
        });
        this.add((Component)this.m_ArrayEditor, "Center");
    }

    public GeneratorPropertyIteratorPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public boolean getEditorActive() {
        return this.m_StatusBox.getSelectedIndex() != 0;
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_StatusBox.setEnabled(true);
        this.m_ArrayEditor.setValue(this.m_Exp.getPropertyArray());
        if (this.m_Exp.getPropertyArray() == null) {
            this.m_StatusBox.setSelectedIndex(0);
            this.m_ConfigureBut.setEnabled(false);
        } else {
            this.m_StatusBox.setSelectedIndex(this.m_Exp.getUsePropertyIterator() ? 1 : 0);
            this.m_ConfigureBut.setEnabled(this.m_Exp.getUsePropertyIterator());
        }
        this.validate();
    }

    protected int selectProperty() {
        PropertySelectorDialog propertySelectorDialog = new PropertySelectorDialog(null, this.m_Exp.getResultProducer());
        propertySelectorDialog.setLocationRelativeTo(this);
        int n = propertySelectorDialog.showDialog();
        if (n == 0) {
            System.err.println("Property Selected");
            PropertyNode[] propertyNodeArray = propertySelectorDialog.getPath();
            Object object = propertyNodeArray[propertyNodeArray.length - 1].value;
            PropertyDescriptor propertyDescriptor = propertyNodeArray[propertyNodeArray.length - 1].property;
            Class<?> clazz = propertyDescriptor.getPropertyType();
            this.m_Exp.setPropertyPath(propertyNodeArray);
            this.m_Exp.setPropertyArray(Array.newInstance(clazz, 1));
            Array.set(this.m_Exp.getPropertyArray(), 0, object);
            this.m_ArrayEditor.setValue(this.m_Exp.getPropertyArray());
            this.m_ArrayEditor.repaint();
            System.err.println("Set new array to array editor");
        } else {
            System.err.println("Cancelled");
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_ConfigureBut) {
            this.selectProperty();
        } else if (actionEvent.getSource() == this.m_StatusBox) {
            for (int i = 0; i < this.m_Listeners.size(); ++i) {
                ActionListener actionListener = (ActionListener)this.m_Listeners.elementAt(i);
                actionListener.actionPerformed(new ActionEvent(this, 1001, "Editor status change"));
            }
            if (this.m_StatusBox.getSelectedIndex() == 0) {
                this.m_Exp.setUsePropertyIterator(false);
                this.m_ConfigureBut.setEnabled(false);
                this.m_ArrayEditor.setEnabled(false);
                this.m_ArrayEditor.setValue(null);
                this.validate();
            } else {
                if (this.m_Exp.getPropertyArray() == null) {
                    this.selectProperty();
                }
                if (this.m_Exp.getPropertyArray() == null) {
                    this.m_StatusBox.setSelectedIndex(0);
                } else {
                    this.m_Exp.setUsePropertyIterator(true);
                    this.m_ConfigureBut.setEnabled(true);
                    this.m_ArrayEditor.setEnabled(true);
                }
                this.validate();
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_Listeners.addElement(actionListener);
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Generator Property Iterator");
            jFrame.getContentPane().setLayout(new BorderLayout());
            GeneratorPropertyIteratorPanel generatorPropertyIteratorPanel = new GeneratorPropertyIteratorPanel();
            jFrame.getContentPane().add((Component)generatorPropertyIteratorPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            System.err.println("Short nap");
            Thread.currentThread();
            Thread.sleep(3000L);
            System.err.println("Done");
            generatorPropertyIteratorPanel.setExperiment(new Experiment());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

