/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import weka.associations.Associator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;

public class AssociatorEvaluation {
    protected StringBuffer m_Result = new StringBuffer();

    protected static String makeOptionString(Associator associator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nGeneral options:\n\n");
        stringBuffer.append("-t <training file>\n");
        stringBuffer.append("\tThe name of the training file.\n");
        if (associator instanceof OptionHandler) {
            stringBuffer.append("\nOptions specific to " + associator.getClass().getName().replaceAll(".*\\.", "") + ":\n\n");
            Enumeration enumeration = ((OptionHandler)((Object)associator)).listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + "\n");
                stringBuffer.append(option.description() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public static String evaluate(String string, String[] stringArray) throws Exception {
        Associator associator;
        try {
            associator = (Associator)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new Exception("Can't find class with name " + string + '.');
        }
        return AssociatorEvaluation.evaluate(associator, stringArray);
    }

    public static String evaluate(Associator associator, String[] stringArray) throws Exception {
        ConverterUtils.DataSource dataSource;
        String string = "";
        if (Utils.getFlag('h', stringArray)) {
            throw new Exception("\nHelp requested.\n" + AssociatorEvaluation.makeOptionString(associator));
        }
        try {
            string = Utils.getOption('t', stringArray);
            if (string.length() == 0) {
                throw new Exception("No training file given!");
            }
            dataSource = new ConverterUtils.DataSource(string);
            if (associator instanceof OptionHandler) {
                ((OptionHandler)((Object)associator)).setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
        }
        catch (Exception exception) {
            throw new Exception("\nWeka exception: " + exception.getMessage() + "\n" + AssociatorEvaluation.makeOptionString(associator));
        }
        AssociatorEvaluation associatorEvaluation = new AssociatorEvaluation();
        return associatorEvaluation.evaluate(associator, new Instances(dataSource.getDataSet()));
    }

    public String evaluate(Associator associator, Instances instances) throws Exception {
        long l = System.currentTimeMillis();
        associator.buildAssociations(instances);
        long l2 = System.currentTimeMillis();
        this.m_Result = new StringBuffer(associator.toString());
        this.m_Result.append("\n=== Evaluation ===\n\n");
        this.m_Result.append("Elapsed time: " + (double)(l2 - l) / 1000.0 + "s");
        this.m_Result.append("\n");
        return this.m_Result.toString();
    }

    public boolean equals(Object object) {
        String string;
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        AssociatorEvaluation associatorEvaluation = (AssociatorEvaluation)object;
        String string2 = this.m_Result.toString().replaceAll("Elapsed time.*", "");
        return string2.equals(string = associatorEvaluation.m_Result.toString().replaceAll("Elapsed time.*", ""));
    }

    public String toSummaryString() {
        return this.toSummaryString("");
    }

    public String toSummaryString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() != 0) {
            stringBuffer.append("\n");
        }
        stringBuffer.append(this.m_Result);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toSummaryString();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("The first argument must be the class name of a kernel");
            }
            String string = stringArray[0];
            stringArray[0] = "";
            System.out.println(AssociatorEvaluation.evaluate(string, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

