/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.associations.AssociationRules;
import weka.associations.AssociationRulesProducer;
import weka.associations.Associator;
import weka.associations.FPGrowth;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Defaults;
import weka.core.Drawable;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Settings;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;
import weka.gui.AbstractPerspective;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PerspectiveInfo;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.plugins.AssociationRuleVisualizePlugin;
import weka.gui.visualize.plugins.TreeVisualizePlugin;

@PerspectiveInfo(ID="weka.gui.explorer.associationspanel", title="Associate", toolTipText="Discover association rules", iconPath="weka/gui/weka_icon_new_small.png")
public class AssociationsPanel
extends AbstractPerspective
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = -6867871711865476971L;
    protected Explorer m_Explorer = null;
    protected GenericObjectEditor m_AssociatorEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel(this.m_AssociatorEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    protected SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    protected JCheckBox m_storeOutput = new JCheckBox("Store output for visualization");
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected Thread m_RunThread;
    protected boolean m_initialSettingsSet;

    public AssociationsPanel() {
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    AssociationsPanel.this.m_OutText.selectAll();
                }
            }
        });
        JPanel historyHolder = new JPanel(new BorderLayout());
        historyHolder.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        historyHolder.add((Component)this.m_History, "Center");
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = AssociationsPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        List<String> selectedEls = AssociationsPanel.this.m_History.getList().getSelectedValuesList();
                        AssociationsPanel.this.historyRightClickPopup(selectedEls, e.getX(), e.getY());
                    } else {
                        AssociationsPanel.this.historyRightClickPopup(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_AssociatorEditor.setClassType(Associator.class);
        this.m_AssociatorEditor.setValue(ExplorerDefaults.getAssociator());
        this.m_AssociatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AssociationsPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = AssociationsPanel.this.m_AssociatorEditor.getCapabilitiesFilter();
                Associator associator = (Associator)AssociationsPanel.this.m_AssociatorEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (associator != null && currentFilter != null && associator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)associator)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    AssociationsPanel.this.m_StartBut.setEnabled(false);
                }
                AssociationsPanel.this.repaint();
            }
        });
        this.m_StartBut.setToolTipText("Starts the associator");
        this.m_StopBut.setToolTipText("Stops the associator");
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean proceed = true;
                if (Explorer.m_Memory.memoryIsLow()) {
                    proceed = Explorer.m_Memory.showMemoryIsLow();
                }
                if (proceed) {
                    AssociationsPanel.this.startAssociator();
                }
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociationsPanel.this.stopAssociator();
            }
        });
        boolean showStoreOutput = GenericObjectEditor.getClassnames(AssociationRuleVisualizePlugin.class.getName()).size() > 0 || GenericObjectEditor.getClassnames(TreeVisualizePlugin.class.getName()).size() > 0;
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Associator"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_CEPanel, "North");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new GridLayout(1, 2));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        buttonsP.add(ssButs);
        buttons.add((Component)buttonsP, "South");
        if (showStoreOutput) {
            buttons.add((Component)this.m_storeOutput, "North");
        }
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Associator output"));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        GridBagLayout gbL = new GridBagLayout();
        GridBagConstraints gbC = new GridBagConstraints();
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(historyHolder, gbC);
        mondo.add(historyHolder);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)mondo, "Center");
    }

    @Override
    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    @Override
    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < attribNames.length; ++i) {
            String type = "(" + Attribute.typeToStringShort(this.m_Instances.attribute(i)) + ") ";
            attribNames[i] = type + this.m_Instances.attribute(i).name();
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    protected void startAssociator() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AssociationsPanel.this.m_CEPanel.addToHistory();
                    AssociationsPanel.this.m_Log.statusMessage("Setting up...");
                    Instances inst = new Instances(AssociationsPanel.this.m_Instances);
                    String grph = null;
                    AssociationRules rulesList = null;
                    Associator associator = (Associator)AssociationsPanel.this.m_AssociatorEditor.getValue();
                    StringBuffer outBuff = new StringBuffer();
                    String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                    String cname = associator.getClass().getName();
                    name = cname.startsWith("weka.associations.") ? name + cname.substring("weka.associations.".length()) : name + cname;
                    String cmd = AssociationsPanel.this.m_AssociatorEditor.getValue().getClass().getName();
                    if (AssociationsPanel.this.m_AssociatorEditor.getValue() instanceof OptionHandler) {
                        cmd = cmd + " " + Utils.joinOptions(((OptionHandler)AssociationsPanel.this.m_AssociatorEditor.getValue()).getOptions());
                    }
                    try {
                        AssociationsPanel.this.m_Log.logMessage("Started " + cname);
                        AssociationsPanel.this.m_Log.logMessage("Command: " + cmd);
                        if (AssociationsPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskStarted();
                        }
                        outBuff.append("=== Run information ===\n\n");
                        outBuff.append("Scheme:       " + cname);
                        if (associator instanceof OptionHandler) {
                            String[] o = ((OptionHandler)((Object)associator)).getOptions();
                            outBuff.append(" " + Utils.joinOptions(o));
                        }
                        outBuff.append("\n");
                        outBuff.append("Relation:     " + inst.relationName() + '\n');
                        outBuff.append("Instances:    " + inst.numInstances() + '\n');
                        outBuff.append("Attributes:   " + inst.numAttributes() + '\n');
                        if (inst.numAttributes() < 100) {
                            for (int i = 0; i < inst.numAttributes(); ++i) {
                                outBuff.append("              " + inst.attribute(i).name() + '\n');
                            }
                        } else {
                            outBuff.append("              [list of attributes omitted]\n");
                        }
                        AssociationsPanel.this.m_History.addResult(name, outBuff);
                        AssociationsPanel.this.m_History.setSingle(name);
                        AssociationsPanel.this.m_Log.statusMessage("Building model on training data...");
                        associator.buildAssociations(inst);
                        outBuff.append("=== Associator model (full training set) ===\n\n");
                        outBuff.append(associator.toString() + '\n');
                        AssociationsPanel.this.m_History.updateResult(name);
                        if (AssociationsPanel.this.m_storeOutput.isSelected()) {
                            if (associator instanceof Drawable) {
                                grph = null;
                                try {
                                    grph = ((Drawable)((Object)associator)).graph();
                                }
                                catch (Exception i) {
                                    // empty catch block
                                }
                            }
                            if (associator instanceof AssociationRulesProducer) {
                                rulesList = null;
                                try {
                                    rulesList = ((AssociationRulesProducer)((Object)associator)).getAssociationRules();
                                }
                                catch (Exception i) {
                                    // empty catch block
                                }
                            }
                        }
                        AssociationsPanel.this.m_Log.logMessage("Finished " + cname);
                        AssociationsPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        AssociationsPanel.this.m_Log.logMessage(ex.getMessage());
                        AssociationsPanel.this.m_Log.statusMessage("See error log");
                    }
                    finally {
                        Vector<Object> visVect = new Vector<Object>();
                        try {
                            Associator configCopy = (Associator)associator.getClass().newInstance();
                            if (configCopy instanceof OptionHandler) {
                                ((OptionHandler)((Object)configCopy)).setOptions(((OptionHandler)((Object)associator)).getOptions());
                            }
                            visVect.add(configCopy);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            visVect.add(associator);
                        }
                        if (grph != null || rulesList != null) {
                            if (grph != null) {
                                visVect.add(grph);
                            }
                            if (rulesList != null) {
                                visVect.add(rulesList);
                            }
                        }
                        AssociationsPanel.this.m_History.addObject(name, visVect);
                        if (this.isInterrupted()) {
                            AssociationsPanel.this.m_Log.logMessage("Interrupted " + cname);
                            AssociationsPanel.this.m_Log.statusMessage("See error log");
                        }
                        AssociationsPanel.this.m_RunThread = null;
                        AssociationsPanel.this.m_StartBut.setEnabled(true);
                        AssociationsPanel.this.m_StopBut.setEnabled(false);
                        if (AssociationsPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void stopAssociator() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    protected void visualizeTree(String dottyString, String treeName) {
        final JFrame jf = new JFrame("Weka Classifier Tree Visualizer: " + treeName);
        jf.setSize(500, 400);
        jf.getContentPane().setLayout(new BorderLayout());
        TreeVisualizer tv = new TreeVisualizer(null, dottyString, (NodePlace)new PlaceNode2());
        jf.getContentPane().add((Component)tv, "Center");
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                jf.dispose();
            }
        });
        jf.setVisible(true);
        tv.fitToScreen();
    }

    protected void historyRightClickPopup(List<String> names, int x, int y) {
        final List<String> selectedNames = names;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem visMainBuffer = new JMenuItem("View in main window");
        if (selectedNames != null && selectedNames.size() == 1) {
            visMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.setSingle((String)selectedNames.get(0));
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        JMenuItem visSepBuffer = new JMenuItem("View in separate window");
        if (selectedNames != null && selectedNames.size() == 1) {
            visSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.openFrame((String)selectedNames.get(0));
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedNames != null && selectedNames.size() == 1) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.saveBuffer((String)selectedNames.get(0));
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer(s)");
        if (selectedNames != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.removeResults(selectedNames);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        Vector visVect = null;
        if (selectedNames != null && selectedNames.size() == 1) {
            visVect = (Vector)this.m_History.getNamedObject(selectedNames.get(0));
        }
        if (visVect != null) {
            Associator temp_model = null;
            if (visVect.get(0) instanceof Associator) {
                temp_model = (Associator)visVect.get(0);
            }
            final Associator model = temp_model;
            JMenuItem reApplyConfig = new JMenuItem("Re-apply this model's configuration");
            if (model != null) {
                reApplyConfig.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AssociationsPanel.this.m_AssociatorEditor.setValue(model);
                    }
                });
            } else {
                reApplyConfig.setEnabled(false);
            }
            resultListMenu.add(reApplyConfig);
        }
        JMenu visPlugins = new JMenu("Plugins");
        boolean availablePlugins = false;
        if (visVect != null) {
            for (Object o : visVect) {
                JMenuItem pluginMenuItem;
                Object plugin2;
                String className;
                int i;
                Vector<String> pluginsVector;
                if (o instanceof AssociationRules) {
                    pluginsVector = GenericObjectEditor.getClassnames(AssociationRuleVisualizePlugin.class.getName());
                    for (i = 0; i < pluginsVector.size(); ++i) {
                        className = pluginsVector.elementAt(i);
                        try {
                            plugin2 = (AssociationRuleVisualizePlugin)WekaPackageClassLoaderManager.objectForName(className);
                            if (plugin2 == null) continue;
                            availablePlugins = true;
                            pluginMenuItem = plugin2.getVisualizeMenuItem((AssociationRules)o, selectedNames.get(0));
                            if (pluginMenuItem == null) continue;
                            visPlugins.add(pluginMenuItem);
                            continue;
                        }
                        catch (Exception plugin2) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                pluginsVector = GenericObjectEditor.getClassnames(TreeVisualizePlugin.class.getName());
                for (i = 0; i < pluginsVector.size(); ++i) {
                    className = pluginsVector.elementAt(i);
                    try {
                        plugin2 = (TreeVisualizePlugin)WekaPackageClassLoaderManager.objectForName(className);
                        if (plugin2 == null) continue;
                        availablePlugins = true;
                        pluginMenuItem = plugin2.getVisualizeMenuItem((String)o, selectedNames.get(0));
                        if (pluginMenuItem == null) continue;
                        visPlugins.add(pluginMenuItem);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (availablePlugins) {
            resultListMenu.add(visPlugins);
        }
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_AssociatorEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(-1);
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_AssociatorEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_AssociatorEditor.getCapabilitiesFilter();
        Associator associator = (Associator)this.m_AssociatorEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (associator != null && currentFilter != null && associator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)associator)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    @Override
    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    @Override
    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    @Override
    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    @Override
    public String getTabTitle() {
        return "Associate";
    }

    @Override
    public String getTabTitleToolTip() {
        return "Discover association rules";
    }

    @Override
    public boolean requiresLog() {
        return true;
    }

    @Override
    public boolean acceptsInstances() {
        return true;
    }

    @Override
    public Defaults getDefaultSettings() {
        return new AssociationsPanelDefaults();
    }

    @Override
    public boolean okToBeActive() {
        return this.m_Instances != null;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.m_isActive) {
            this.settingsChanged();
        }
    }

    @Override
    public void settingsChanged() {
        if (this.getMainApplication() != null) {
            if (!this.m_initialSettingsSet) {
                this.m_initialSettingsSet = true;
                Associator initialA = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), AssociationsPanelDefaults.ASSOCIATOR_KEY, AssociationsPanelDefaults.ASSOCIATOR, Environment.getSystemWide());
                this.m_AssociatorEditor.setValue(initialA);
            }
            Font outputFont = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), AssociationsPanelDefaults.OUTPUT_FONT_KEY, AssociationsPanelDefaults.OUTPUT_FONT, Environment.getSystemWide());
            this.m_OutText.setFont(outputFont);
            Color textColor = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), AssociationsPanelDefaults.OUTPUT_TEXT_COLOR_KEY, AssociationsPanelDefaults.OUTPUT_TEXT_COLOR, Environment.getSystemWide());
            this.m_OutText.setForeground(textColor);
            Color outputBackgroundColor = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), AssociationsPanelDefaults.OUTPUT_BACKGROUND_COLOR_KEY, AssociationsPanelDefaults.OUTPUT_BACKGROUND_COLOR, Environment.getSystemWide());
            this.m_OutText.setBackground(outputBackgroundColor);
            this.m_History.setBackground(outputBackgroundColor);
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Associator");
            jf.getContentPane().setLayout(new BorderLayout());
            AssociationsPanel sp = new AssociationsPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }

    protected static final class AssociationsPanelDefaults
    extends Defaults {
        public static final String ID = "weka.gui.explorer.associationspanel";
        protected static final Settings.SettingKey ASSOCIATOR_KEY = new Settings.SettingKey("weka.gui.explorer.associationspanel.initialAssociator", "Initial associator", "On startup, set this associator as the default one");
        protected static final Associator ASSOCIATOR = new FPGrowth();
        protected static final Settings.SettingKey OUTPUT_FONT_KEY = new Settings.SettingKey("weka.gui.explorer.associationspanel.outputFont", "Font for text output", "Font to use in the output area");
        protected static final Font OUTPUT_FONT = new Font("Monospaced", 0, 12);
        protected static final Settings.SettingKey OUTPUT_TEXT_COLOR_KEY = new Settings.SettingKey("weka.gui.explorer.associationspanel.outputFontColor", "Output text color", "Color of output text");
        protected static final Color OUTPUT_TEXT_COLOR = Color.black;
        protected static final Settings.SettingKey OUTPUT_BACKGROUND_COLOR_KEY = new Settings.SettingKey("weka.gui.explorer.associationspanel.outputBackgroundColor", "Output background color", "Output background color");
        protected static final Color OUTPUT_BACKGROUND_COLOR = Color.white;
        private static final long serialVersionUID = 1108450683775771792L;

        public AssociationsPanelDefaults() {
            super(ID);
            this.m_defaults.put(ASSOCIATOR_KEY, ASSOCIATOR);
            this.m_defaults.put(OUTPUT_FONT_KEY, OUTPUT_FONT);
            this.m_defaults.put(OUTPUT_TEXT_COLOR_KEY, OUTPUT_TEXT_COLOR);
            this.m_defaults.put(OUTPUT_BACKGROUND_COLOR_KEY, OUTPUT_BACKGROUND_COLOR);
        }
    }
}

