% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_args.R
\name{f_args}
\alias{f_args}
\alias{f_sig}
\alias{p_sig}
\title{Names and Arguments of Functions}
\usage{
f_args(..., char = NULL)

f_sig(..., char = NULL)

p_sig(..., char = NULL, pattern = NULL)
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, except list.
A vector of unquoted "functions" or characters.}

\item{char}{(name to) a character vector. Use this argument if 
\code{...} fails or if you call the function from another function. 
If used, argument \code{...} is ignored.}

\item{pattern}{a regular expression. See the example.}
}
\description{
\code{f_args} is a wrapper of the base function \code{\link{args}}.

\code{f_sig} prints the name and arguments of one or several functions in a readable 
style. It wraps the function \code{sig::sig}.

\code{p_sig} prints the name and arguments of the functions exported by one or 
several packages. It wraps the function \code{sig::list_sigs}.
}
\examples{
f_args(mean, p_display)
f_sig( mean, p_display)

library(sos)
p_sig("sos")
p_sig(RWsearch, sos, pattern = "^f")

}
