\name{RXuclars}
\alias{RXuclars}
\title{Maximum Likelihood Least Angle Regression on Uncorrelated X-Components}
\description{
  Apply least angle regression estimation to the uncorrelated
  components of a possibly ill-conditioned linear regression model
  and generate normal-theory maximum likelihood TRACE displays.
}
\usage{
RXuclars(form, data, rscale = 1, type = "lar", trace = FALSE, Gram, 
    eps = .Machine$double.eps, max.steps, use.Gram = TRUE, omdmin = 9.9e-13) 
}
\arguments{
  \item{form}{A regression formula [y~x1+x2+...] suitable for use with lm().}
  \item{data}{Data frame containing observations on all variables in the formula.}
  \item{rscale}{One of three possible choices (0, 1 or 2) for rescaling of variables
   as they are being "centered" to remove non-essential ill-conditioning:  0 implies no
   rescaling; 1 implies divide each variable by its standard error; 2 implies rescale as
   in option 1 but re-express answers as in option 0.}
  \item{type}{One of "lasso", "lar" or "forward.stagewise" for function lars(). Names can be
   abbreviated to any unique substring. Default in RXlarlso() is "lar".}
  \item{trace}{If TRUE, lars() function prints out its progress.}
  \item{Gram}{Specify a fixed X'X matrix to lars(); useful for repeated runs (bootstrap) where
   a large X'X stays the same.}
  \item{eps}{The effective zero for lars().}
  \item{max.steps}{lars() upper limit for the number of steps taken; the default is 8 * min(m, n-1),
   with m the number of variables, and n the number of samples.}
  \item{use.Gram}{When the number m of variables is larger than N, then you may not want lars()
   to precompute the Gram matrix. Default is use.Gram=TRUE.}
  \item{omdmin}{Strictly positive minimum allowed value for one-minus-delta (default = 9.9e-013.)}
}
\details{RXuclars() applies Least Angle Regression to the uncorrelated components of a
 possibly ill-conditioned set of X-variables.  A closed-form expression for the lars/lasso
 shrinkage delta factors exits in this case: Delta(i) = max{0,1-k/abs[PC(i)]}, where PC(i)
 is the principal correlation between Y and the i-th principal coordinates of X. Note that
 the k-factor in this formulation is limited to a subset of [0,1].  MCAL=0 occurs at k=0,
 while MCAL = P results when k is the maximum absolute principal correlation. 
}
\value{ An output list object of class RXuclars:
  \item{form}{The regression formula specified as the first argument.}
  \item{data}{Name of the data.frame object specified as the second argument.}
  \item{p}{Number of regression predictor variables.}
  \item{n}{Number of complete observations after removal of all missing values.}
  \item{r2}{Numerical value of R-square goodness-of-fit statistic.}
  \item{s2}{Numerical value of the residual mean square estimate of error.}
  \item{prinstat}{Listing of principal statistics.}
  \item{crlqstat}{Listing of criteria for maximum likelihood selection of path Q-shape.}
  \item{qmse}{Numerical value of Q-shape most likely to be optimal.}
  \item{qp}{Numerical value of the Q-shape actually used for shrinkage.}
  \item{coef}{Matrix of shrinkage-ridge regression coefficient estimates.}
  \item{risk}{Matrix of MSE risk estimates for fitted coefficients.}
  \item{exev}{Matrix of excess MSE eigenvalues (ordinary least squares minus ridge.)}
  \item{infd}{Matrix of direction cosines for the estimated inferior direction, if any.}
  \item{spat}{Matrix of shrinkage pattern multiplicative delta factors.}
  \item{mlik}{Listing of criteria for maximum likelihood selection of M-extent-of-shrinkage.}
  \item{sext}{Listing of summary statistics for all M-extents-of-shrinkage.}
}
\references{
  Efron B, Hastie T, Johnstone I, Tibshirani R. (2004)
  Least angle regression. \emph{Ann. Statis.} \bold{32}, 407--499 (with discussion.)

  Obenchain RL. (1994-2005)
  Shrinkage Regression: ridge, BLUP, Bayes, spline and Stein. \bold{www.iquest.net/~softrx}.

  Obenchain RL. (2005) \emph{RXshrink.PDF}  ../../../library/RXshrink
}
\author{Bob Obenchain <softrx@iquest.net>}
\seealso{\code{\link{RXlarlso}}.}
\examples{
    data(longley2)
    form <- GNP~GNP.deflator+Unemployed+Armed.Forces+Population+Year+Employed
    rxuobj <- RXuclars(form, data=longley2)
    rxuobj
    names(rxuobj)
    plot(rxuobj)
}
\keyword{regression}
\keyword{hplot}