% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooroh_accessor.R
\name{cumhbd}
\alias{cumhbd}
\title{Computes the realized inbreeding coefficient}
\usage{
cumhbd(zres, T = NULL)
}
\arguments{
\item{zres}{The name of the zres object created by the zoorun function.}

\item{T}{The value chosen to define the base population. When T is not provided, all HBD classes
are considered to estimate the inbreeding coefficient.}
}
\value{
An array with the compute inbreeding coefficients for all the individuals in the analysis.
}
\description{
Computes the realized inbreeding coefficient with respect to a base population
by summing the autozygosity from all HBD class with a rate lower or equal to the threshold T.
This amounts to set the base population approximately 0.5*T generations ago.
HBD classes with a higher rate are then no longer considered as autozygous.
}
