% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotPP}
\alias{plotPP}
\title{Plotting function for posterior checks}
\usage{
plotPP(pp, y = NULL, umi.eps = FALSE, i = 1, log.scale = TRUE)
}
\arguments{
\item{pp}{List object returned by \code{testPrior} function.}

\item{y}{One of "mean", "median", "var", "cor", or \code{NULL}. If \code{NULL} then the ratios between the predicted and the actual variances across all sampled genes and neighbourhoods are shown as boxplots for all tested values of the prior parameter \code{gamma}. If \code{y} equals "mean", "median", or "var", the mean, median, or variance is plotted for all \code{gamma} values. If \code{y} equal "cor", then the correlation between the total transcript count of a cell and the local noise estimate \code{epsilon} is plotted for all values of \code{gamma}. Default is \code{NULL}.}

\item{umi.eps}{Logical. If \code{TRUE} then a scatter plot of the local noise estimate \code{epsilon} and the total transcript count is produced for a given element \code{i} of the \code{pp$noise} corresponding to a value of the prior parameter \code{gamma}. Default is \code{FALSE}.}

\item{i}{Positive integer number. Index of \code{pp$noise}, corresponding to a value of the prior parameter \code{gamma} to be used for plotting is \code{umi.eps=TRUE}. Default is 1.}

\item{log.scale}{Logical. If \code{TRUE} then the ratio between the predicted and the actual variance is transformed to a log2-scale prior to computations and plotting. If \code{umi.eps=TRUE}, total transcript counts and \code{epsilon} estimates are log2-transformed for plotting. Default is \code{TRUE}.}
}
\description{
This function plots various statistics for the posterior check
}
