% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{noiseBaseFit}
\alias{noiseBaseFit}
\title{Function for computing a fit to the baseline of gene expression variability}
\usage{
noiseBaseFit(x, step = 0.01, thr = 0.05)
}
\arguments{
\item{x}{Matrix of gene expression values with genes as rows and cells as columns.}

\item{step}{Positive real number between 0 and 1. Bin size for the computation. The interval of mean gene expression values is divided into bins with equal number of data points and \code{step} equals the fraction of data points in each bin. Default is 0.01.}

\item{thr}{Positive real number between 0 and 1. In each mean expression bin defined by \code{step} the lowest \code{thr}-quantile of the gene expression variance distribution is selected. The selected data points from all bins are used for a second order polynomial fit of the variance-mean dependence in log space. Default is 0.05.}
}
\value{
List object of three components:
\item{nfit}{model fit as returned by the \code{lm} function.}
\item{m}{mean expression of all genes}
\item{v}{expression variance of all genes}
}
\description{
This function fits a second order polynomial to the baseline variance-mean dependence across all genes in log space.
}
\examples{
x <- noiseBaseFit(intestinalDataSmall,step=.01,thr=.05)
}
