% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_diagnostics_leverage.R
\name{ptLeverage}
\alias{ptLeverage}
\alias{agLeverage}
\alias{srLeverage}
\alias{titerLeverage}
\title{Calculate point leverage}
\usage{
agLeverage(map, antigens = TRUE, sera = TRUE)

srLeverage(map, antigens = TRUE, sera = TRUE)

titerLeverage(map, antigens = TRUE, sera = TRUE)
}
\arguments{
\item{map}{An acmap object}

\item{antigens}{Antigens to include when calculating the rmsd of the
procrustes (specified by name or index or TRUE/FALSE for all/none)}

\item{sera}{Sera to include when calculating the rmsd of the procrustes
(specified by name or index or TRUE/FALSE for all/none)}
}
\value{
Returns a numeric vector of the leverage calculated for each of the
points.
}
\description{
These functions attempt to estimate leverage of each antigen, sera or titer
by removing it from the data, relaxing the map, then calculating the rmsd of
the procrustes comparison between the original and newly relaxed map. Column
bases will be recalculated unless you have specifed them as fixed with
\code{fixedColBases()}.
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}
}
\concept{map diagnostic functions}
