\name{getStructureList}
\docType{methods}
\alias{getStructureList}
\alias{getStructureList-methods}
\alias{getStructureList,DVH-method}
\alias{getStructureList,DVH.list-method}
\alias{getStructureList,list-method}
\title{
Extract a DVH list of one or more structure(s)
}
\description{
This function is designed to isolate one or more structure(s) from a list of DVH lists (generated by applying the \code{read.DVH()} command to multiple input files)
}
\usage{
\S4method{getStructureList}{DVH}(x, structures)

\S4method{getStructureList}{DVH.list}(x, structures)

\S4method{getStructureList}{list}(x, structures)

}
\arguments{
  \item{x}{
	Can represent either a list of DVH lists (generated by \code{read.DVH()} applied to multiple input files) or a single object of class \code{DVH} or \code{DVH.list}.
}
  \item{structures}{
		Vector used to sub-select structures from \code{x}; may be a character vector containing structure names (regular expressions may be specified if desired, see \code{\link{regex}} for more details). This parameter is ignored when \code{x} is of class \code{DVH}.
	}
}
\value{
Returns a single DVH list
}
\author{
Reid F. Thompson (\email{reid.thompson@gmail.com})
}
\seealso{
\code{\link[RadOnc:DVH.list-class]{DVH.list}}
}
\examples{
	patients <- list(janedoe, johndoe)
	getStructureList(patients, "(?i)Liver")
}
\keyword{ methods }
\keyword{ manip }
