% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSI_mu.R
\name{PSI_mu}
\alias{PSI_mu}
\title{Ausiliary function  that evaluates the SVD of F_c on a pre-specified grid divided by the singular values to the square.}
\usage{
PSI_mu(x, N, c, K, L1)
}
\arguments{
\item{x}{the pre-specified grid}

\item{N}{number of singular values to compute}

\item{c}{parameter indexing the singular values}

\item{K}{ordre of the Legendre quadrature}

\item{L1}{number of Legendre polynomials used in the computation of the coefficients of the singular functions;}
}
\value{
a list containing, in order:

- ipeven

- ipodd
}
\description{
Ausiliary function  that evaluates the SVD of F_c on a pre-specified grid divided by the singular values to the square.
}
\examples{
library(orthopolynom)
library(polynom)
library(tmvtnorm)
library(ks)
library(sfsmisc)
library(snowfall)
library(fourierin)
library(rdetools)
library(statmod)
library(RCEIM)
library(robustbase)
library(VGAM)
library(RandomCoefficients)
#### Bandwidth 1
L =15
L1 = L+1
N2 = max(L,3)
twoN = 2*N2
#### Bandwidth 1
c= 1
K1 = max(twoN+2,30)
K = K1
res2 <-  legendrequad(K)
t <- res2[[1]]
psi_even <- abs(PSI_mu(t,N2,c,K, L1)[[1]])

}
