% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-cumulative-functions.R
\name{kurtosis_vec}
\alias{kurtosis_vec}
\title{Compute Kurtosis of a Vector}
\usage{
kurtosis_vec(.x)
}
\arguments{
\item{.x}{A numeric vector of length four or more.}
}
\value{
The kurtosis of a vector
}
\description{
This function takes in a vector as it's input and will return the kurtosis
of that vector. The length of this vector must be at least four numbers. The
kurtosis explains the sharpness of the peak of a distribution of data.

\verb{((1/n) * sum(x - mu\})^4) / ((()1/n) * sum(x - mu)^2)^2}
}
\details{
A function to return the kurtosis of a vector.
}
\examples{
set.seed(123)
kurtosis_vec(rnorm(100, 3, 2))

}
\seealso{
\url{https://en.wikipedia.org/wiki/Kurtosis}

Other Vector Function: 
\code{\link{cgmean}()},
\code{\link{chmean}()},
\code{\link{ckurtosis}()},
\code{\link{cmean}()},
\code{\link{cmedian}()},
\code{\link{crange}()},
\code{\link{csd}()},
\code{\link{cskewness}()},
\code{\link{cvar}()},
\code{\link{euclidean_distance}()},
\code{\link{rw_range}()},
\code{\link{skewness_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
