% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvt_read.R
\name{rvn_rvt_read}
\alias{rvn_rvt_read}
\title{Read .rvt (Raven time series) file}
\usage{
rvn_rvt_read(filename, tzone = "UTC")
}
\arguments{
\item{filename}{the name of the .rvt file (with .rvt extension included ), either relative
to the working directory or absolute.}

\item{tzone}{string indicating the timezone of the data provided in filename (default "UTC")}
}
\value{
Returns an xts time series with at least one dataset (multiple for :MultiData files)
}
\description{
This routine reads in a valid Raven time series input (.rvt) file and returns the
information as an xts time series.
}
\details{
It supports :MultiData, :Data, :ObservedData,
:BasinInflowHydrograph, and most of the other :Data-like time series commands. It does
NOT support the master .rvt file with :Gauge or :GriddedForcing commands

The timezone is provided by the tzone argument as "UTC" by default, and should be adjusted by
the user to the local time zone as needed, based on the model run.
}
\examples{
# read in rvt file
system.file('extdata','GlenAllan.rvt',package="RavenR") \%>\%
rvn_rvt_read(.) -> rvt
plot(rvt$TEMP_DAILY_MIN)

}
\author{
James R. Craig, University of Waterloo
}
