% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_utilities.R
\name{cmax}
\alias{cmax}
\title{cmax}
\usage{
cmax(x, na.rm = FALSE)
}
\arguments{
\item{x}{object to apply the max function to}

\item{na.rm}{whether to remove na values from the calculation}
}
\value{
x with the max value in each column determined
}
\description{
Applies the base::max function across columns.
}
\details{
It applies the base::max function over
columns, which is advantageous for calculating the max within a column
rather than the max of the whole data frame. The default base::max will not work
properly for data frames and other structures in applying over columns or different periods.

This function was included for usage with the apply.<period> and \code{\link{rvn_apply_wyearly}}
function, as the base::max function does not work properly across columns.
}
\examples{
data(rvn_hydrograph_data)
cmax(rvn_hydrograph_data$hyd$Sub43_obs, na.rm=TRUE)

rvn_apply_wyearly(rvn_hydrograph_data$hyd, cmax, na.rm=TRUE)

}
\seealso{
\code{\link[RavenR]{rvn_apply_wyearly}} where this function can be applied for the water year,
and the xts functions such as \code{\link[xts]{apply.yearly}} and \code{\link[xts]{apply.monthly}}
}
