% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{nameClusters}
\alias{nameClusters}
\title{Clusters renaming}
\usage{
nameClusters(data.sample, method, RclusTool.env = initParameters())
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{method}{character vector specifying the clustering method (already performed) to use.}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}
}
\value{
data.sample list containing features, profiles and clustering results with updated labels names.
}
\description{
Assign a class name to each cluster obtained by unsupervised or semi-supervised classification, thanks to the use of a training set and the majority rule method.
}
\details{
nameClusters assigns a class name to each cluster obtained by unsupervised or semi-supervised classification, thanks to the use of a training set and the majority rule method
}
\examples{
\dontrun{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1)
x <- computeUnSupervised(x, K=3, method.name="K-means")

nameClusters(x, method = "K-means_preprocessed")


}
}
\keyword{internal}
