% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{countItems}
\alias{countItems}
\title{Manually counting the number of cells in colonies}
\usage{
countItems(profile, feature = NULL, imgdir = NULL, image = NULL)
}
\arguments{
\item{profile}{matrix of profile data (signals in columns).}

\item{feature}{vector of features data.}

\item{imgdir}{character vector specifying the path of the images directory.}

\item{image}{character vector specifying the name of the considered image in imgdir.}
}
\value{
nbItemsTot number of cells manually counted on each image.
}
\description{
Display the profile and the image of each particle and allow the user to manually count the number of cells by simple left-clicking on each of them.
}
\details{
countItems displays the profile and the image of each particle and allows the user to manually count the number of cells by simple left-clicking on each of them
}
\examples{
\donttest{ 
dat <- rbind(matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 6, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

sig <- data.frame(ID=rep(1:150, each=30), SIGNAL=rep(dnorm(seq(-2,2,length=30)),150))
tf2 <- tempfile()
write.table(sig, tf2, sep=",", dec=".")

x <- importSample(file.features=tf1, file.profiles=tf2)

nbItems <- countItems(x$profiles[[1]])


}
}
\seealso{
\code{\link{itemsModel}}, \code{\link{computeItemsSample}}
}
\keyword{internal}
