% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{importSample}
\alias{importSample}
\title{Sample importation}
\usage{
importSample(
  file.features = "",
  file.meta = "",
  file.profiles = "",
  file.RDS = "",
  file.config = "",
  dir.images = "",
  dir.save = "",
  sepFeat = ",",
  decFeat = ".",
  naFeat = c("", "NA"),
  sepSig = ",",
  decSig = ".",
  naSig = c("", "NA"),
  headerCSV = TRUE,
  RclusTool.env = new.env(),
  ...
)
}
\arguments{
\item{file.features}{character vector specifying the csv file containing features data.}

\item{file.meta}{character vector specifying the txt file containing metadata.}

\item{file.profiles}{character vector specifying the csv file containing profiles data.}

\item{file.RDS}{character vector for a RDS file containing a data.sample object. This file is automatically saved when importing a (csv-)file-features. When both a csv-file-features and a RDS file are given, the last one is ignored.}

\item{file.config}{character vector for the name of the configuration file.}

\item{dir.images}{character vector containing the path of images directory.}

\item{dir.save}{character vector specifying path of the working directory to save results ; "" to not save any results}

\item{sepFeat}{character specifying the field separator for the csv file containing features data.}

\item{decFeat}{character specifying the decimal points for the csv file containing features data.}

\item{naFeat}{vector containing missing values for the csv file containing features data.}

\item{sepSig}{character specifying the field separator for the csv file containing profiles data.}

\item{decSig}{character specifying the decimal point for the csv file containing profiles data.}

\item{naSig}{vector containing missing values for the csv file containing profiles data.}

\item{headerCSV}{boolean if TRUE (default) the file contains the names of the variables as its first line.}

\item{RclusTool.env}{environment in which data and intermediate results are stored.}

\item{...}{parameters adressed to read.csv functions.}
}
\value{
data.sample loaded data.sample.
}
\description{
Import the required and the optional files, and build a dataset.
}
\details{
function to import sample from CSV files; sample is preprocessed
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

metadat <- rbind("First metadata: ...", "Second metadata: ...")
tf2 <- tempfile()
writeLines(metadat, tf2)

x <- importSample(file.features=tf1, file.meta=tf2)


}
\seealso{
\code{\link{loadSample}}
}
