% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aRnova.R
\name{repMeasAnova}
\alias{repMeasAnova}
\title{Repeated measures ANOVA}
\usage{
repMeasAnova(.withinfactors, .withinlevels)
}
\arguments{
\item{.withinfactors}{list of within-subject factors}

\item{.withinlevels}{list of within-subject variables}
}
\value{
None
}
\description{
Dialog box to (i) select the within-subject variables corresponding
to the factors defined in  \code{\link{repMeasAnovaSetup}}, (ii) select the
between-suject factors, (iii) set options and (iv) launch the repeated 
measures anova.
}
\details{
Options:
\itemize{
\item{\code{'SS type'}} {type of sum of squares, default: \code{type = 2}. 
See Details in \code{\link[car]{Anova}}}
\item{\code{'Effect size'}} {compute and prints effect size (partial eta squared)}
\item{\code{'Summary statistics for groups'}} {prints summary statistics for
groups formed by all combinations of factors}
\item{\code{'Pairwise comparisons of means'}} {performs post-hoc Tukey's HSD test  
on significant (p < .05) or close to significant (p < 0.1) effects.}  
}
On OK, the following operations are carried out:
\itemize{
 \item {} {Generates a dataset containing complete cases and converted 
 from 'wide' to 'long' format (extension  \code{.cplt.lg}), with the following columns added:
   \itemize{
     \item{\code{'id'} (factor)} {identifies the subjects.}
     \item{\code{'DV'} (numeric)} {the measure or dependent variable.}
     \item{\code{'trial'} (int)} {variable that differentiates multiple 
     measures (\code{'DV'}) from the same subject (\code{'id'}).}
     \item {\code{'<factorA>'} (factor)} {levels of the 
     within-suject factor A (one column per within subject factor)}
     \item {\code{'<factorA.factorB:...>'} (factor)} {factor that 
     differentiates multiple measures from groups or subjects with same factors 
     levels}
   }
 This 'long' dataset is useful for ploting means and post-hoc analysis  
 }
 \item{} {Computes repeated measure ANOVA using \code{\link[car]{Anova}}} 
 \item{} {Computes effect sizes (partial eta squared)}
 \item{} {Prints a summary of marginal statistics 
 (count, min, max, mean, ds)}
 \item{} {runs post-hoc analysis on significant or close to significant effects}
}
}
\seealso{
\code{\link{repMeasAnovaSetup}} for the definition of 
within factors, \code{\link[car]{Anova}} for the computation of ANOVA
}
\author{
Jessica Mange \email{jessica.mange@unicaen.fr}

Arnaud Travert \email{arnaud.travert@unicaen.fr}
}
